/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HeadCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TargetType targetType = TargetType.NPC;
        Integer duration = null;
        String skin = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getIntegerFrom(arg);
                dB.echoDebug("...head duration set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("PLAYER", arg)) {
                targetType = TargetType.PLAYER;
                dB.echoDebug("...will affect the player!");
                continue;
            }
            if (aH.matchesValueArg("skin", arg, aH.ArgumentType.String)) {
                skin = aH.getStringFrom(arg);
                dB.echoDebug("...will have " + skin + "'s head");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("target", (Object)targetType).addObject("skin", skin);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        String skin = (String)scriptEntry.getObject("skin");
        ItemStack item = new ItemStack(Material.SKULL_ITEM, 1, 3);
        ItemMeta itemMeta = item.getItemMeta();
        ((SkullMeta)itemMeta).setOwner(skin);
        item.setItemMeta(itemMeta);
        if (target.name() == "NPC") {
            NPC npc = scriptEntry.getNPC().getCitizen();
            if (!npc.hasTrait(Equipment.class)) {
                npc.addTrait(Equipment.class);
            }
            Equipment trait = (Equipment)npc.getTrait(Equipment.class);
            trait.set(1, item);
        } else {
            Player player = scriptEntry.getPlayer().getPlayerEntity();
            player.getInventory().setHelmet(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

