/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.Poses;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PoseCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.ASSUME;
        TargetType targetType = TargetType.NPC;
        String id = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, ASSUME, REMOVE", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.String)) {
                id = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesArg("PLAYER", arg)) {
                targetType = TargetType.PLAYER;
                dB.echoDebug("Setting pose on PLAYER!");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT);
        }
        if (targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("target", (Object)targetType).addObject("action", (Object)action).addObject("id", id);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        dNPC npc = scriptEntry.getNPC();
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String id = (String)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj(target.toString(), npc.toString()) + aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id));
        switch (action) {
            case ASSUME: {
                if (target.name() == "NPC") {
                    ((Poses)npc.getCitizen().getTrait(Poses.class)).assumePose(id);
                } else {
                    Player player = scriptEntry.getPlayer().getPlayerEntity();
                    Location location = player.getLocation();
                    location.setYaw(((Poses)npc.getCitizen().getTrait(Poses.class)).getPose(id).getYaw());
                    location.setPitch(((Poses)npc.getCitizen().getTrait(Poses.class)).getPose(id).getPitch());
                    player.teleport(location);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

