/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.interfaces.dRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.commands.core.DefineCommand;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.scripts.commands.core.FlagCommand;
import net.aufdemrand.denizen.scripts.commands.core.ForEachCommand;
import net.aufdemrand.denizen.scripts.commands.core.IfCommand;
import net.aufdemrand.denizen.scripts.commands.core.LogCommand;
import net.aufdemrand.denizen.scripts.commands.core.NoteCommand;
import net.aufdemrand.denizen.scripts.commands.core.QueueCommand;
import net.aufdemrand.denizen.scripts.commands.core.RandomCommand;
import net.aufdemrand.denizen.scripts.commands.core.ResetCommand;
import net.aufdemrand.denizen.scripts.commands.core.RunCommand;
import net.aufdemrand.denizen.scripts.commands.core.RuntaskCommand;
import net.aufdemrand.denizen.scripts.commands.core.WaitCommand;
import net.aufdemrand.denizen.scripts.commands.core.YamlCommand;
import net.aufdemrand.denizen.scripts.commands.core.ZapCommand;
import net.aufdemrand.denizen.scripts.commands.entity.AnimateCommand;
import net.aufdemrand.denizen.scripts.commands.entity.AttackCommand;
import net.aufdemrand.denizen.scripts.commands.entity.BurnCommand;
import net.aufdemrand.denizen.scripts.commands.entity.CastCommand;
import net.aufdemrand.denizen.scripts.commands.entity.FeedCommand;
import net.aufdemrand.denizen.scripts.commands.entity.FlyCommand;
import net.aufdemrand.denizen.scripts.commands.entity.HeadCommand;
import net.aufdemrand.denizen.scripts.commands.entity.HealCommand;
import net.aufdemrand.denizen.scripts.commands.entity.HurtCommand;
import net.aufdemrand.denizen.scripts.commands.entity.InvisibleCommand;
import net.aufdemrand.denizen.scripts.commands.entity.LookCommand;
import net.aufdemrand.denizen.scripts.commands.entity.MountCommand;
import net.aufdemrand.denizen.scripts.commands.entity.NameplateCommand;
import net.aufdemrand.denizen.scripts.commands.entity.RemoveCommand;
import net.aufdemrand.denizen.scripts.commands.entity.ShootCommand;
import net.aufdemrand.denizen.scripts.commands.entity.SpawnCommand;
import net.aufdemrand.denizen.scripts.commands.entity.TeleportCommand;
import net.aufdemrand.denizen.scripts.commands.item.DisplayItemCommand;
import net.aufdemrand.denizen.scripts.commands.item.EngraveCommand;
import net.aufdemrand.denizen.scripts.commands.item.EquipCommand;
import net.aufdemrand.denizen.scripts.commands.item.GiveCommand;
import net.aufdemrand.denizen.scripts.commands.item.InventoryCommand;
import net.aufdemrand.denizen.scripts.commands.item.ScribeCommand;
import net.aufdemrand.denizen.scripts.commands.item.TakeCommand;
import net.aufdemrand.denizen.scripts.commands.npc.AnchorCommand;
import net.aufdemrand.denizen.scripts.commands.npc.AssignmentCommand;
import net.aufdemrand.denizen.scripts.commands.npc.DisengageCommand;
import net.aufdemrand.denizen.scripts.commands.npc.EngageCommand;
import net.aufdemrand.denizen.scripts.commands.npc.FishCommand;
import net.aufdemrand.denizen.scripts.commands.npc.FollowCommand;
import net.aufdemrand.denizen.scripts.commands.npc.HealthCommand;
import net.aufdemrand.denizen.scripts.commands.npc.LookcloseCommand;
import net.aufdemrand.denizen.scripts.commands.npc.PauseCommand;
import net.aufdemrand.denizen.scripts.commands.npc.PoseCommand;
import net.aufdemrand.denizen.scripts.commands.npc.RenameCommand;
import net.aufdemrand.denizen.scripts.commands.npc.SitCommand;
import net.aufdemrand.denizen.scripts.commands.npc.StandCommand;
import net.aufdemrand.denizen.scripts.commands.npc.TriggerCommand;
import net.aufdemrand.denizen.scripts.commands.npc.VulnerableCommand;
import net.aufdemrand.denizen.scripts.commands.npc.WalkCommand;
import net.aufdemrand.denizen.scripts.commands.player.ChatCommand;
import net.aufdemrand.denizen.scripts.commands.player.CompassCommand;
import net.aufdemrand.denizen.scripts.commands.player.ExperienceCommand;
import net.aufdemrand.denizen.scripts.commands.player.GroupCommand;
import net.aufdemrand.denizen.scripts.commands.player.ListenCommand;
import net.aufdemrand.denizen.scripts.commands.player.NarrateCommand;
import net.aufdemrand.denizen.scripts.commands.player.OxygenCommand;
import net.aufdemrand.denizen.scripts.commands.player.PermissionCommand;
import net.aufdemrand.denizen.scripts.commands.player.ShowFakeCommand;
import net.aufdemrand.denizen.scripts.commands.server.AnnounceCommand;
import net.aufdemrand.denizen.scripts.commands.server.ExecuteCommand;
import net.aufdemrand.denizen.scripts.commands.server.ScoreboardCommand;
import net.aufdemrand.denizen.scripts.commands.world.AnimateChestCommand;
import net.aufdemrand.denizen.scripts.commands.world.BreakCommand;
import net.aufdemrand.denizen.scripts.commands.world.ChunkLoadCommand;
import net.aufdemrand.denizen.scripts.commands.world.CopyBlockCommand;
import net.aufdemrand.denizen.scripts.commands.world.CreateWorldCommand;
import net.aufdemrand.denizen.scripts.commands.world.DropCommand;
import net.aufdemrand.denizen.scripts.commands.world.ExplodeCommand;
import net.aufdemrand.denizen.scripts.commands.world.FireworkCommand;
import net.aufdemrand.denizen.scripts.commands.world.MidiCommand;
import net.aufdemrand.denizen.scripts.commands.world.ModifyBlockCommand;
import net.aufdemrand.denizen.scripts.commands.world.PlayEffectCommand;
import net.aufdemrand.denizen.scripts.commands.world.PlaySoundCommand;
import net.aufdemrand.denizen.scripts.commands.world.SignCommand;
import net.aufdemrand.denizen.scripts.commands.world.StrikeCommand;
import net.aufdemrand.denizen.scripts.commands.world.SwitchCommand;
import net.aufdemrand.denizen.scripts.commands.world.TimeCommand;
import net.aufdemrand.denizen.scripts.commands.world.ViewerCommand;
import net.aufdemrand.denizen.scripts.commands.world.WeatherCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRegistry
implements dRegistry {
    public Denizen denizen;
    private Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    private Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    public CommandRegistry(Denizen denizen) {
        this.denizen = denizen;
    }

    @Override
    public boolean register(String commandName, RegistrationableInstance commandInstance) {
        this.instances.put(commandName.toUpperCase(), (AbstractCommand)commandInstance);
        this.classes.put(((AbstractCommand)commandInstance).getClass(), commandName.toUpperCase());
        return true;
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    @Override
    public AbstractCommand get(String commandName) {
        if (this.instances.containsKey(commandName.toUpperCase())) {
            return this.instances.get(commandName.toUpperCase());
        }
        return null;
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public void registerCoreMembers() {
        this.registerCoreMember(AnchorCommand.class, "ANCHOR", "anchor [id:<name>] [assume/add/remove/walkto/walknear] (range:<#>)", 2);
        this.registerCoreMember(AnimateCommand.class, "ANIMATE", "animate [<entity>|...] [animation:<name>]", 1);
        this.registerCoreMember(AnimateChestCommand.class, "ANIMATECHEST", "animatechest [<location>] ({open}/close) (sound:{true}/false)", 1);
        this.registerCoreMember(AnnounceCommand.class, "ANNOUNCE", "announce [\"<text>\"] (to_ops) (to_flagged:<flag>)", 1);
        this.registerCoreMember(AssignmentCommand.class, "ASSIGNMENT", "assignment [{set}/remove] (script:<name>)", 1);
        this.registerCoreMember(AttackCommand.class, "ATTACK", "attack (cancel) (<entity>|...) (target:<entity>)", 0);
        this.registerCoreMember(BreakCommand.class, "BREAK", "break [<location>] (entity:<entity>) (radius:<#.#>)", 1);
        this.registerCoreMember(BurnCommand.class, "BURN", "burn [<entity>|...] (duration:<value>)", 1);
        this.registerCoreMember(CastCommand.class, "CAST, POTION", "cast [<effect>] (remove) (duration:<value>) (power:<#>) (<entity>|...)", 1);
        this.registerCoreMember(ChatCommand.class, "CHAT", "chat [\"<text>\"] (targets:<entity>|...)", 1);
        this.registerCoreMember(ChunkLoadCommand.class, "CHUNKLOAD", "chunkload ({add}/remove/removeall) [<location>] (duration:<value>)", 1);
        this.registerCoreMember(CompassCommand.class, "COMPASS", "compass [<location>]", 1);
        this.registerCoreMember(CooldownCommand.class, "COOLDOWN", "cooldown (duration:<value>) (global) (script:<name>)", 1);
        this.registerCoreMember(CopyBlockCommand.class, "COPYBLOCK", "copyblock [location:<location>] [to:<location>]", 1);
        this.registerCoreMember(CreateWorldCommand.class, "CREATEWORLD", "createworld [<name>] (g:<generator>)", 1);
        this.registerCoreMember(DefineCommand.class, "DEFINE", "define [<id>] [<value>]", 2);
        this.registerCoreMember(DetermineCommand.class, "DETERMINE", "determine [<value>]", 1);
        this.registerCoreMember(DisengageCommand.class, "DISENGAGE", "disengage", 0);
        this.registerCoreMember(DisplayItemCommand.class, "DISPLAYITEM", "displayitem (remove) [<item>] [<location>] (duration:<value>)", 2);
        this.registerCoreMember(DropCommand.class, "DROP", "drop [<item>/<entity>/<xp>] [<location>] (qty:<#>)", 1);
        this.registerCoreMember(EngageCommand.class, "ENGAGE", "engage (duration:<value>)", 0);
        this.registerCoreMember(EngraveCommand.class, "ENGRAVE", "engrave (set/remove)", 0);
        this.registerCoreMember(EquipCommand.class, "EQUIP", "equip (hand:<item>) (head:<item>) (chest:<item>) (legs:<item>) (boots:<item>)", 1);
        this.registerCoreMember(ExecuteCommand.class, "EXECUTE", "execute [as_player/as_op/as_npc/as_server] [<Bukkit command>]", 2);
        this.registerCoreMember(ExperienceCommand.class, "EXPERIENCE", "experience [{set}/give/take] (level) [<#>]", 2);
        this.registerCoreMember(ExplodeCommand.class, "EXPLODE", "explode (power:<#.#>) (<location>) (fire) (breakblocks)", 0);
        this.registerCoreMember(FailCommand.class, "FAIL", "fail (script:<name>)", 0);
        this.registerCoreMember(FeedCommand.class, "FEED", "feed (amt:<#>) (target:<entity>|...)", 0);
        this.registerCoreMember(FinishCommand.class, "FINISH", "finish (script:<name>)", 0);
        this.registerCoreMember(FireworkCommand.class, "FIREWORK", "firework (<location>) (power:<#>) (type:<name>/random) (primary:<color>|...) (fade:<color>|...) (flicker) (trail)", 0);
        this.registerCoreMember(FishCommand.class, "FISH", "fish (catchfish) (stop) (<location>) (catchpercent:<#>)", 1);
        this.registerCoreMember(FlagCommand.class, "FLAG", "flag ({player}/npc/global) [<name>([<#>])](:<action>)[:<value>] (duration:<value>)", 1);
        this.registerCoreMember(FlyCommand.class, "FLY", "fly (cancel) [<entity>|...] (origin:<location>) (destinations:<location>|...) (speed:<#.#>)", 1);
        this.registerCoreMember(FollowCommand.class, "FOLLOW", "follow (stop) (lead:<#.#>)", 0);
        this.registerCoreMember(ForEachCommand.class, "FOREACH", "foreach [location:<location>|...] [<script>]", 0);
        this.registerCoreMember(GiveCommand.class, "GIVE", "give [money/<item>] (qty:<#>) (engrave)", 1);
        this.registerCoreMember(GroupCommand.class, "GROUP", "group [add/remove] [<group>] (world:<name>)", 2);
        this.registerCoreMember(HeadCommand.class, "HEAD", "head (player) [skin:<name>]", 0);
        this.registerCoreMember(HealCommand.class, "HEAL", "heal (<#.#>) (<entity>|...)", 0);
        this.registerCoreMember(HealthCommand.class, "HEALTH", "health (state:true/false/toggle) (set_max:<#>)", 1);
        this.registerCoreMember(HurtCommand.class, "HURT", "hurt (<#.#>) (<entity>|...)", 0);
        this.registerCoreMember(IfCommand.class, "IF", "if [<value>] (!)(<operator> <value>) (&&/|| ...) [<commands>] (else <commands>)", 2);
        this.registerCoreMember(InventoryCommand.class, "INVENTORY", "inventory [open/copy/move/swap/add/remove/keep/exclude/fill/clear] (origin:<entity>/<location>) [destination:<entity>/<location>]", 2);
        this.registerCoreMember(InvisibleCommand.class, "INVISIBLE", "invisible [player/npc] [state:true/false/toggle]", 2);
        this.registerCoreMember(ListenCommand.class, "LISTEN", "listen ({new}/cancel/finish) [kill/block/item/itemdrop/travel] [<requirements>]  [script:<name>] (id:<name>)", 2);
        this.registerCoreMember(LogCommand.class, "LOG", "log [<text>] (type:severe/info/warning/fine/finer/finest) [file:<name>]", 2);
        this.registerCoreMember(LookCommand.class, "LOOK", "look (<entity>|...) [<location>]", 1);
        this.registerCoreMember(LookcloseCommand.class, "LOOKCLOSE", "lookclose [state:true/false]", 1);
        this.registerCoreMember(MidiCommand.class, "MIDI", "midi [file:<name>] [<location>/listeners:<player>|...] (tempo:<#.#>)", 1);
        this.registerCoreMember(MountCommand.class, "MOUNT", "mount (cancel) [<entity>|...] (<location>)", 0);
        this.registerCoreMember(ModifyBlockCommand.class, "MODIFYBLOCK", "modifyblock [<location>] [<block>] (radius:<#>) (height:<#>) (depth:<#>)", 2);
        this.registerCoreMember(NameplateCommand.class, "NAMEPLATE", "nameplate [<chatcolor>] [set:<text>] (target:<player>)  +--> Requires ProtocolLib", 1);
        this.registerCoreMember(NarrateCommand.class, "NARRATE", "narrate [\"<text>\"] (targets:<player>|...) (format:<name>)", 1);
        this.registerCoreMember(NoteCommand.class, "NOTE", "note [<Notable dObject>] [as:<name>]", 2);
        this.registerCoreMember(OxygenCommand.class, "OXYGEN", "oxygen (type:maximum/remaining) (mode:set/add/remove) [qty:<#>]", 1);
        this.registerCoreMember(PlayEffectCommand.class, "PLAYEFFECT", "playeffect [<location>] [effect:<name>] (data:<#.#>) (visibility:<#.#>) (qty:<#>) (offset:<#.#>)", 2);
        this.registerCoreMember(PlaySoundCommand.class, "PLAYSOUND", "playsound [<location>] [sound:<name>] (volume:<#.#>) (pitch:<#.#>)", 2);
        this.registerCoreMember(PermissionCommand.class, "PERMISSION", "permission [add|remove] [permission] (player:<name>) (group:<name>) (world:<name>)", 2);
        this.registerCoreMember(PoseCommand.class, "POSE", "pose (player/npc) [id:<name>]", 1);
        this.registerCoreMember(PauseCommand.class, "PAUSE", "pause [waypoints/navigation]", 1);
        this.registerCoreMember(QueueCommand.class, "QUEUE", "queue (queue:<id>) [clear/pause/resume/delay:<#>]", 1);
        this.registerCoreMember(RandomCommand.class, "RANDOM", "random [<#>]", 1);
        this.registerCoreMember(RemoveCommand.class, "REMOVE", "remove [<entity>|...] (region:<name>)", 0);
        this.registerCoreMember(RenameCommand.class, "RENAME", "rename [<npc>] [<name>]", 1);
        this.registerCoreMember(ResetCommand.class, "RESET", "reset [fails/finishes/cooldown] (script:<name>)", 1);
        this.registerCoreMember(RunCommand.class, "RUN", "run [<script>] (path:<name>) (as:<player>/<npc>) (define:<element>|...) (id:<name>) (delay:<value>) (loop) (qty:<#>)", 1);
        this.registerCoreMember(RuntaskCommand.class, "RUNTASK", "runtask [<name>] (instantly) (queue(:<name>)) (delay:<#>) (define:<element>|...)", 1);
        this.registerCoreMember(ScoreboardCommand.class, "SCOREBOARD", "scoreboard [set/remove/show/hide] [<name>] [value:<name>] (priority:<#>)", 1);
        this.registerCoreMember(ScribeCommand.class, "SCRIBE", "scribe [script:<name>] (give/drop/equip) (<item>) (<location>)", 1);
        this.registerCoreMember(ShootCommand.class, "SHOOT", "shoot [<entity>|...] (origin:<player>/<npc>) (destination:<location>) (speed:<#.#>) (duration:<value>) (script:<name>)", 1);
        this.registerCoreMember(ShowFakeCommand.class, "SHOWFAKE", "showfake [<material>] [<location>|...] (d:<duration>{10s})", 2);
        this.registerCoreMember(SignCommand.class, "SIGN", "sign (type:{sign_post}/wall_sign) [\"<line>|...\"] [<location>] (direction:n/e/w/s)", 1);
        this.registerCoreMember(SitCommand.class, "SIT", "sit (<location>)", 0);
        this.registerCoreMember(SpawnCommand.class, "SPAWN", "spawn [<entity>|...] (<location>) (target:<entity>)", 1);
        this.registerCoreMember(StandCommand.class, "STAND", "stand", 0);
        this.registerCoreMember(StrikeCommand.class, "STRIKE", "strike (no_damage) [<location>]", 1);
        this.registerCoreMember(SwitchCommand.class, "SWITCH", "switch [<location>] (state:[{toggle}/on/off]) (duration:<value>)", 1);
        this.registerCoreMember(TakeCommand.class, "TAKE", "take [money/iteminhand/<item>] (qty:<#>)", 1);
        this.registerCoreMember(TeleportCommand.class, "TELEPORT", "teleport (<entity>|...) (<location>)", 1);
        this.registerCoreMember(TimeCommand.class, "TIME", "time [type:{global}/player] [<value>] (world:<name>)", 1);
        this.registerCoreMember(TriggerCommand.class, "TRIGGER", "trigger [name:chat/click/damage/proximity] (state:true/false) (cooldown:<#.#>) (radius:<#>)", 2);
        this.registerCoreMember(ViewerCommand.class, "VIEWER", "viewer ({create <location>}/modify/remove) [id:<name>] (type:{sign_post}/wall_sign) (display:{location}/score/logged_in) (direction:n/e/w/s)", 2);
        this.registerCoreMember(VulnerableCommand.class, "VULNERABLE", "vulnerable (state:{true}/false/toggle)", 0);
        this.registerCoreMember(WaitCommand.class, "WAIT", "wait (<duration>) (queue:<name>)", 0);
        this.registerCoreMember(WalkCommand.class, "WALK, WALKTO", "walk [<location>] (speed:<#>) (auto_range)", 1);
        this.registerCoreMember(WeatherCommand.class, "WEATHER", "weather [type:{global}/player] [sunny/storm/thunder] (world:<name>)", 1);
        this.registerCoreMember(YamlCommand.class, "YAML", "yaml [load/create/save:<file>]/[write:<key>]/[write:<key> value:<value>] [id:<name>]", 1);
        this.registerCoreMember(ZapCommand.class, "ZAP", "zap (<script>:)[<step>] (<duration>)", 0);
        dB.echoApproval("Loaded core commands: " + this.instances.keySet().toString());
    }

    private <T extends AbstractCommand> void registerCoreMember(Class<T> cmd, String names, String hint, int args) {
        for (String name : names.split(", ")) {
            try {
                ((AbstractCommand)cmd.newInstance()).activate().as(name).withOptions(hint, args);
            }
            catch (Exception e) {
                dB.echoError("Could not register command " + name + ": " + e.getMessage());
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractCommand member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }
}

