/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class FlagCommand
extends AbstractCommand
implements Listener {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("duration") && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asElement());
                continue;
            }
            if (arg.matches("NPC, DENIZEN") && !scriptEntry.hasObject("mcentity")) {
                if (!scriptEntry.hasNPC()) {
                    throw new InvalidArgumentsException("Specified NPC-type flag with no valid NPC reference.");
                }
                scriptEntry.addObject("mcentity", Element.valueOf(scriptEntry.getNPC().identify()));
                continue;
            }
            if (arg.matches("PLAYER") && !scriptEntry.hasObject("mcentity")) {
                if (!scriptEntry.hasPlayer()) {
                    throw new InvalidArgumentsException("Specified Player-type flag with no valid Player reference.");
                }
                scriptEntry.addObject("mcentity", Element.valueOf(scriptEntry.getPlayer().identify()));
                continue;
            }
            if (arg.matches("GLOBAL, SERVER") && !scriptEntry.hasObject("entity")) {
                scriptEntry.addObject("mcentity", Element.valueOf("null"));
                continue;
            }
            if (arg.matchesPrefix("entity") && !scriptEntry.hasObject("mcentity")) {
                scriptEntry.addObject("mcentity", new Element(arg.getValue()));
                continue;
            }
            if (arg.getPrefixAndValue().split(":", 3).length > 1) {
                String[] flagArgs = arg.getPrefixAndValue().split(":", 3);
                scriptEntry.addObject("name", Element.valueOf(flagArgs[0].toUpperCase()));
                if (flagArgs.length == 2) {
                    if (flagArgs[1].equals("+") || flagArgs[1].equals("++")) {
                        scriptEntry.addObject("action", Element.valueOf("INCREASE"));
                        scriptEntry.addObject("value", Element.valueOf("1"));
                        continue;
                    }
                    if (flagArgs[1].equals("-") || flagArgs[1].equals("--")) {
                        scriptEntry.addObject("action", Element.valueOf("DECREASE"));
                        scriptEntry.addObject("value", Element.valueOf("1"));
                        continue;
                    }
                    if (flagArgs[1].startsWith("!")) {
                        scriptEntry.addObject("action", Element.valueOf("DELETE"));
                        continue;
                    }
                    if (flagArgs[1].startsWith("<-")) {
                        scriptEntry.addObject("action", Element.valueOf("REMOVE"));
                        continue;
                    }
                    scriptEntry.addObject("action", Element.valueOf("SET_VALUE"));
                    scriptEntry.addObject("value", Element.valueOf(arg.getPrefixAndValue().split(":")[1]));
                    continue;
                }
                if (flagArgs.length != 3) continue;
                if (flagArgs[1].startsWith("->")) {
                    scriptEntry.addObject("action", Element.valueOf("INSERT"));
                } else if (flagArgs[1].startsWith("<-")) {
                    scriptEntry.addObject("action", Element.valueOf("REMOVE"));
                } else if (flagArgs[1].startsWith("|")) {
                    scriptEntry.addObject("action", Element.valueOf("SPLIT"));
                } else if (flagArgs[1].startsWith("+")) {
                    scriptEntry.addObject("action", Element.valueOf("INCREASE"));
                } else if (flagArgs[1].startsWith("-")) {
                    scriptEntry.addObject("action", Element.valueOf("DECREASE"));
                } else if (flagArgs[1].startsWith("*")) {
                    scriptEntry.addObject("action", Element.valueOf("MULTIPLY"));
                } else if (flagArgs[1].startsWith("/")) {
                    scriptEntry.addObject("action", Element.valueOf("DIVIDE"));
                }
                if (!scriptEntry.hasObject("action")) {
                    scriptEntry.addObject("action", Element.valueOf("SET_VALUE"));
                }
                scriptEntry.addObject("value", Element.valueOf(flagArgs[2]));
                continue;
            }
            if (scriptEntry.hasObject("name")) continue;
            scriptEntry.addObject("name", arg.asElement());
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Must specify a FLAG name.");
        }
        if (!scriptEntry.hasObject("value")) {
            scriptEntry.addObject("value", new Element("true"));
        }
        if (!scriptEntry.hasObject("mcentity")) {
            if (!scriptEntry.hasPlayer()) {
                throw new InvalidArgumentsException("Specified Player-type flag with no valid Player reference.");
            }
            scriptEntry.addObject("mcentity", Element.valueOf(scriptEntry.getPlayer().identify()));
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", Element.valueOf("SET_BOOLEAN"));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String name = scriptEntry.getElement("name").asString();
        String value = scriptEntry.getElement("value").asString();
        Duration duration = scriptEntry.hasObject("duration") ? Duration.valueOf(scriptEntry.getElement("duration").asString()) : new Duration(-1.0);
        Action action = Action.valueOf(scriptEntry.getElement("action").asString());
        dEntity entity = dEntity.valueOf(scriptEntry.getElement("mcentity").asString());
        dPlayer player = null;
        if (entity == null) {
            player = dPlayer.valueOf(scriptEntry.getElement("mcentity").asString());
        }
        int index = -1;
        if (name.contains("[")) {
            try {
                index = Integer.valueOf(name.split("\\[")[1].replace("]", ""));
            }
            catch (Exception e) {
                index = -1;
            }
            name = name.split("\\[")[0];
        }
        FlagManager.Flag flag = null;
        dB.report(this.getName(), aH.debugObj("Name", name) + (index > 0 ? aH.debugObj("Index", String.valueOf(index)) : "") + aH.debugUniqueObj("Action/Value", action.toString(), value != null ? value : "null") + (duration.getSeconds() > 0.0 ? duration.debug() : "") + (entity == null ? (player == null ? "entity='server'" : player.debug()) : entity.debug()));
        if (entity == null) {
            flag = player == null ? this.denizen.flagManager().getGlobalFlag(name) : this.denizen.flagManager().getPlayerFlag(player.getName(), name);
        } else if (entity.isNPC()) {
            flag = this.denizen.flagManager().getNPCFlag(scriptEntry.getNPC().getId(), name);
        } else if (entity.isLivingEntity() && entity.getLivingEntity() instanceof Player) {
            flag = this.denizen.flagManager().getPlayerFlag(((Player)entity.getLivingEntity()).getName(), name);
        } else {
            dB.echoError("Invalid entity specified!");
            return;
        }
        switch (action) {
            case INCREASE: 
            case DECREASE: 
            case MULTIPLY: 
            case DIVIDE: {
                double currentValue = flag.get(index).asDouble();
                flag.set(Double.toString(this.math(currentValue, Double.valueOf(value), action)), index);
                break;
            }
            case SET_BOOLEAN: {
                flag.set("true", index);
                break;
            }
            case SET_VALUE: {
                flag.set(value, index);
                break;
            }
            case INSERT: {
                flag.add(value);
                break;
            }
            case REMOVE: {
                flag.remove(value, index);
                break;
            }
            case SPLIT: {
                flag.split(value);
                break;
            }
            case DELETE: {
                flag.clear();
            }
        }
        if (duration.getSeconds() > 0.0) {
            flag.setExpiration(System.currentTimeMillis() + Double.valueOf(duration.getSeconds() * 1000.0).longValue());
        } else {
            flag.setExpiration(0L);
        }
    }

    private double math(double currentValue, double value, Action flagAction) {
        switch (flagAction) {
            case INCREASE: {
                return currentValue + value;
            }
            case DECREASE: {
                return currentValue - value;
            }
            case MULTIPLY: {
                return currentValue * value;
            }
            case DIVIDE: {
                return currentValue / value;
            }
        }
        return 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        GLOBAL,
        NPC,
        PLAYER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        DELETE;

    }
}

