/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class InventoryCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation") && arg.matchesPrefix("origin, o, source, s, items, i, from, f")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (!arg.matchesArgumentType(dLocation.class)) continue;
                scriptEntry.addObject("originLocation", arg.asType(dLocation.class).setPrefix("location"));
                continue;
            }
            if (scriptEntry.hasObject("destinationEntity") || scriptEntry.hasObject("destinationLocation") || !arg.matchesPrefix("destination, d, target, to, t")) continue;
            if (arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("destinationEntity", arg.asType(dEntity.class));
                continue;
            }
            if (!arg.matchesArgumentType(dLocation.class)) continue;
            scriptEntry.addObject("destinationLocation", arg.asType(dLocation.class).setPrefix("location"));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        if (!scriptEntry.hasObject("destinationEntity") && !scriptEntry.hasObject("destinationLocation")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "DESTINATION");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = (dLocation)scriptEntry.getObject("originLocation");
        dEntity destinationEntity = (dEntity)scriptEntry.getObject("destinationEntity");
        dLocation destinationLocation = (dLocation)scriptEntry.getObject("destinationLocation");
        dInventory origin = null;
        dInventory destination = null;
        if (originLocation != null) {
            origin = new dInventory(originLocation.getBlock().getState());
        } else if (originEntity != null) {
            origin = new dInventory(originEntity.getLivingEntity());
        }
        if (destinationLocation != null) {
            destination = new dInventory(destinationLocation.getBlock().getState());
        } else if (destinationEntity != null) {
            destination = new dInventory(destinationEntity.getLivingEntity());
        }
        switch (action) {
            case OPEN: {
                scriptEntry.getPlayer().getPlayerEntity().openInventory(destination.getInventory());
                return;
            }
            case COPY: {
                origin.replace(destination);
                return;
            }
            case MOVE: {
                origin.replace(destination);
                origin.clear();
                return;
            }
            case SWAP: {
                dInventory temp = new dInventory(destination.getInventoryType()).add(destination.getContents());
                origin.replace(destination);
                temp.replace(origin);
                return;
            }
            case ADD: {
                destination.add(origin.getContents());
                return;
            }
            case REMOVE: {
                destination.remove(origin.getContents());
                return;
            }
            case KEEP: {
                destination.keep(origin.getContents());
                return;
            }
            case EXCLUDE: {
                destination.exclude(origin.getContents());
                return;
            }
            case FILL: {
                destination.fill(origin.getContents());
                return;
            }
            case CLEAR: {
                destination.clear();
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        OPEN,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR;

    }
}

