/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.flags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class FlagManager {
    private Denizen denizen;

    public FlagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public static boolean playerHasFlag(dPlayer player, String flagName) {
        if (player == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(player.getName(), flagName).size() > 0;
    }

    public static boolean npcHasFlag(dNPC npc, String flagName) {
        if (npc == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(npc.getId(), flagName).size() > 0;
    }

    public static boolean serverHasFlag(String flagName) {
        if (flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flagName).size() > 0;
    }

    public Flag getNPCFlag(int npcid, String flagName) {
        return new Flag("NPCs." + npcid + ".Flags." + flagName.toUpperCase(), flagName, "n@" + npcid);
    }

    public Flag getGlobalFlag(String flagName) {
        return new Flag("Global.Flags." + flagName.toUpperCase(), flagName, "SERVER");
    }

    public Flag getPlayerFlag(String playerName, String flagName) {
        return new Flag("Players." + playerName + ".Flags." + flagName.toUpperCase(), flagName, "p@" + playerName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Value {
        private List<String> values;
        private int index = -1;

        private Value(List<String> values) {
            this.values = values;
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
        }

        private void adjustIndex() {
            if (this.index < 0) {
                this.index = this.size() - 1;
            }
        }

        public boolean asBoolean() {
            this.adjustIndex();
            try {
                return !this.values.get(this.index).equalsIgnoreCase("FALSE");
            }
            catch (Exception e) {
                return false;
            }
        }

        public double asDouble() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index));
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public int asInteger() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index)).intValue();
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String asCommaSeparatedList() {
            this.adjustIndex();
            String returnList = "";
            for (String string : this.values) {
                returnList = returnList + string + ", ";
            }
            return returnList.substring(0, returnList.length() - 2);
        }

        public dList asList() {
            this.adjustIndex();
            return new dList(this.values);
        }

        public dList asList(String prefix) {
            this.adjustIndex();
            return new dList(this.values, prefix);
        }

        public String asString() {
            this.adjustIndex();
            try {
                return this.values.get(this.index);
            }
            catch (Exception e) {
                return "";
            }
        }

        public int asSize() {
            this.adjustIndex();
            return this.values.size();
        }

        public Object asAutoDetectedObject() {
            this.adjustIndex();
            String arg = this.values.get(this.index);
            try {
                if (aH.matchesInteger(arg)) {
                    return aH.getIntegerFrom(arg);
                }
                if (aH.matchesDouble(arg)) {
                    return aH.getDoubleFrom(arg);
                }
                if (arg.equalsIgnoreCase("true")) {
                    return true;
                }
                if (arg.equalsIgnoreCase("false")) {
                    return false;
                }
                if (arg.contains("|")) {
                    ArrayList<String> toList = new ArrayList<String>();
                    return new dList((List<String>)toList);
                }
                return arg;
            }
            catch (Exception e) {
                return "";
            }
        }

        private Value get(int i) {
            this.index = i - 1;
            this.adjustIndex();
            return this;
        }

        public boolean isEmpty() {
            if (this.values.isEmpty()) {
                return true;
            }
            this.adjustIndex();
            if (this.size() < this.index + 1) {
                return true;
            }
            return this.values.get(this.index).equals("");
        }

        private int size() {
            return this.values.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Flag {
        private Value value;
        private String flagPath;
        private String flagName;
        private String flagOwner;
        private long expiration = -1L;

        Flag(String flagPath, String flagName, String flagOwner) {
            this.flagPath = flagPath;
            this.flagName = flagName;
            this.flagOwner = flagOwner;
            this.rebuild();
        }

        public boolean contains(String stringValue) {
            this.checkExpired();
            for (String val : this.value.values) {
                if (val.equalsIgnoreCase(stringValue)) {
                    return true;
                }
                try {
                    if (!Double.valueOf(val).equals(Double.valueOf(stringValue))) continue;
                    return true;
                }
                catch (NumberFormatException e) {
                }
            }
            return false;
        }

        public List<String> values() {
            this.checkExpired();
            return this.value.values;
        }

        public Value get(int index) {
            this.checkExpired();
            return this.value.get(index);
        }

        public void clear() {
            String type;
            ArrayList<String> world_script_events = new ArrayList<String>();
            HashMap<String, Object> context = new HashMap<String, Object>();
            dPlayer player = null;
            if (dPlayer.matches(this.flagOwner)) {
                player = dPlayer.valueOf(this.flagOwner);
            }
            dNPC npc = null;
            if (dNPC.matches(this.flagOwner)) {
                npc = dNPC.valueOf(this.flagOwner);
            }
            if (player != null) {
                type = "player";
                world_script_events.add("player flag cleared");
                world_script_events.add("player flag " + this.flagName + " cleared");
            } else if (npc != null) {
                type = "npc";
                world_script_events.add("npc flag cleared");
                world_script_events.add("npc flag " + this.flagName + " cleared");
            } else {
                type = "server";
                world_script_events.add("server flag cleared");
                world_script_events.add("server flag " + this.flagName + " cleared");
            }
            context.put("owner", this.flagOwner);
            context.put("name", this.flagName);
            context.put("type", type);
            context.put("old_value", this.value.size() > 1 ? new dList(FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) : (this.value.size() == 1 ? new Element(this.value.get(0).asString()) : "null"));
            world_script_events.add("flag cleared");
            FlagManager.this.denizen.getSaves().set(this.flagPath, null);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
            this.rebuild();
            WorldScriptHelper.doEvents(world_script_events, npc, player != null ? player.getPlayerEntity() : null, context);
        }

        public Value getFirst() {
            this.checkExpired();
            return this.value.get(1);
        }

        public Value getLast() {
            this.checkExpired();
            return this.value.get(this.value.size());
        }

        public void set(Object obj) {
            this.set(obj, -1);
        }

        public void set(Object obj, int index) {
            this.checkExpired();
            if (index < 0) {
                index = this.size();
            }
            if (this.size() == 0) {
                this.value.values.add((String)obj);
            } else if (index > 0) {
                if (this.value.values.size() > index - 1) {
                    this.value.values.remove(index - 1);
                    this.value.values.add(index - 1, (String)obj);
                } else {
                    this.value.values.add((String)obj);
                }
            }
            this.save();
            this.rebuild();
        }

        public int add(Object obj) {
            this.checkExpired();
            this.value.values.add((String)obj);
            this.save();
            this.rebuild();
            return this.size();
        }

        public int split(Object obj) {
            this.checkExpired();
            String[] split = ((String)obj).replace("li@", "").split("\\|");
            if (split.length > 0) {
                for (String val : split) {
                    if (val.length() <= 0) continue;
                    this.value.values.add(val);
                }
                this.save();
                this.rebuild();
            }
            return this.size();
        }

        public void remove(Object obj) {
            this.remove(obj, -1);
        }

        public void remove(Object obj, int index) {
            this.checkExpired();
            if (index <= 0 && obj != null) {
                int x = 0;
                for (String val : this.value.values) {
                    block8: {
                        if (val.equalsIgnoreCase(String.valueOf(obj))) {
                            this.value.values.remove(x);
                            break;
                        }
                        try {
                            if (!Double.valueOf(val).equals(Double.valueOf((String)obj))) break block8;
                            this.value.values.remove(x);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++x;
                }
            } else if (index < this.size()) {
                this.value.values.remove(index - 1);
            }
            this.save();
            this.rebuild();
        }

        public void setExpiration(Long expiration) {
            this.expiration = expiration;
            this.save();
        }

        public int size() {
            this.checkExpired();
            return this.value.size();
        }

        public void save() {
            String type;
            ArrayList<String> world_script_events = new ArrayList<String>();
            HashMap<String, Object> context = new HashMap<String, Object>();
            dPlayer player = null;
            if (dPlayer.matches(this.flagOwner)) {
                player = dPlayer.valueOf(this.flagOwner);
            }
            dNPC npc = null;
            if (dNPC.matches(this.flagOwner)) {
                npc = dNPC.valueOf(this.flagOwner);
            }
            if (player != null) {
                type = "player";
                world_script_events.add("player flag changed");
                world_script_events.add("player flag " + this.flagName + " changed");
            } else if (npc != null) {
                type = "npc";
                world_script_events.add("npc flag changed");
                world_script_events.add("npc flag " + this.flagName + " changed");
            } else {
                type = "server";
                world_script_events.add("server flag changed");
                world_script_events.add("server flag " + this.flagName + " changed");
            }
            context.put("owner", this.flagOwner);
            context.put("name", this.flagName);
            context.put("type", type);
            context.put("old_value", this.value.size() > 1 ? new dList(FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) : (this.value.size() == 1 ? new Element(this.value.get(0).asString()) : "null"));
            world_script_events.add("flag changed");
            FlagManager.this.denizen.getSaves().set(this.flagPath, (Object)this.value.values);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", this.expiration > 0L ? Long.valueOf(this.expiration) : null);
            this.rebuild();
            WorldScriptHelper.doEvents(world_script_events, npc, player != null ? player.getPlayerEntity() : null, context);
        }

        public String toString() {
            this.checkExpired();
            return this.flagOwner.equalsIgnoreCase("SERVER") ? "fl@" + this.flagName : "fl[" + this.flagOwner + "]@" + this.flagName;
        }

        public boolean checkExpired() {
            this.rebuild();
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration") && this.expiration > 1L && this.expiration < System.currentTimeMillis()) {
                FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
                FlagManager.this.denizen.getSaves().set(this.flagPath, null);
                this.rebuild();
                dB.echoDebug("// '" + this.flagName + "' has expired! " + this.flagPath);
                return true;
            }
            return false;
        }

        public Duration expiration() {
            return new Duration((double)(this.expiration - System.currentTimeMillis()) / 1000.0);
        }

        @Deprecated
        public String expirationTime() {
            this.rebuild();
            long seconds = (this.expiration - System.currentTimeMillis()) / 1000L;
            long days = seconds / 86400L;
            long hours = (seconds - days * 86400L) / 3600L;
            long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
            seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
            String timeString = "";
            if (days > 0L) {
                timeString = String.valueOf(days) + "d ";
            }
            if (hours > 0L) {
                timeString = timeString + String.valueOf(hours) + "h ";
            }
            if (minutes > 0L && days == 0L) {
                timeString = timeString + String.valueOf(minutes) + "m ";
            }
            if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
                timeString = timeString + String.valueOf(seconds) + "s";
            }
            return timeString.trim();
        }

        private Flag rebuild() {
            ArrayList<String> cval;
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration")) {
                this.expiration = FlagManager.this.denizen.getSaves().getLong(this.flagPath + "-expiration");
            }
            if ((cval = FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) == null) {
                cval = new ArrayList<String>();
                cval.add(FlagManager.this.denizen.getSaves().getString(this.flagPath, ""));
            }
            this.value = new Value(cval);
            return this;
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public void doAction(Action action, Element value, Integer index) {
            String val;
            String string = val = value != null ? value.asString() : null;
            if (index == null) {
                index = -1;
            }
            if (action == null) {
                return;
            }
            switch (action) {
                case INCREASE: 
                case DECREASE: 
                case MULTIPLY: 
                case DIVIDE: {
                    double currentValue = this.get(index).asDouble();
                    this.set(Double.toString(this.math(currentValue, Double.valueOf(value.asString()), action)), index);
                    break;
                }
                case SET_BOOLEAN: {
                    this.set("true", index);
                    break;
                }
                case SET_VALUE: {
                    this.set(val, index);
                    break;
                }
                case INSERT: {
                    this.add(val);
                    break;
                }
                case REMOVE: {
                    this.remove(val, index);
                    break;
                }
                case SPLIT: {
                    this.split(val);
                    break;
                }
                case DELETE: {
                    this.clear();
                }
            }
        }

        private double math(double currentValue, double value, Action flagAction) {
            switch (flagAction) {
                case INCREASE: {
                    return currentValue + value;
                }
                case DECREASE: {
                    return currentValue - value;
                }
                case MULTIPLY: {
                    return currentValue * value;
                }
                case DIVIDE: {
                    return currentValue / value;
                }
            }
            return 0.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        DELETE;

    }
}

