/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FlyCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("destinations") && arg.matchesPrefix("destination, destinations, d")) {
                scriptEntry.addObject("destinations", ((dList)arg.asType(dList.class)).filter(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("origin", arg.asType(dLocation.class).setPrefix("origin"));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (scriptEntry.hasObject("speed") || !arg.matchesPrimitive(aH.PrimitiveType.Double)) continue;
            scriptEntry.addObject("speed", arg.asElement());
        }
        scriptEntry.defaultObject("origin", scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null, scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null);
        scriptEntry.defaultObject("speed", new Element(1.2));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ENTITIES");
        }
        if (!scriptEntry.hasObject("origin")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ORIGIN");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation origin = (dLocation)scriptEntry.getObject("origin");
        List entities = (List)scriptEntry.getObject("entities");
        final List destinations = scriptEntry.hasObject("destinations") ? (List)scriptEntry.getObject("destinations") : new ArrayList();
        final Element speed = (Element)scriptEntry.getObject("speed");
        boolean cancel = scriptEntry.hasObject("cancel");
        dB.report(this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("origin", origin) + aH.debugObj("entities", entities.toString()) + aH.debugObj("speed", speed) + (destinations.size() > 0 ? aH.debugObj("destinations", destinations.toString()) : ""));
        if (!cancel) {
            for (dEntity entity : entities) {
                if (!entity.isSpawned()) {
                    entity.spawnAt(origin);
                    continue;
                }
                entity.teleport(origin);
            }
        } else {
            Position.dismount(Conversion.convert(entities));
            return;
        }
        Position.mount(Conversion.convert(entities));
        final Entity entity = ((dEntity)entities.get(entities.size() - 1)).getBukkitEntity();
        final Player player = scriptEntry.getPlayer().getPlayerEntity();
        final boolean freeflight = destinations.size() > 0;
        BukkitRunnable task = new BukkitRunnable(){
            Location location = null;
            Boolean flying = true;

            public void run() {
                if (freeflight) {
                    this.location = player.getEyeLocation().add(player.getEyeLocation().getDirection().multiply(30));
                } else if (destinations.size() > 0) {
                    this.location = (Location)destinations.get(0);
                } else {
                    this.flying = false;
                }
                if (this.flying.booleanValue() && entity.isValid() && !entity.isEmpty()) {
                    if (!Rotation.isFacingLocation(entity, this.location, 50.0f)) {
                        Rotation.faceLocation(entity, this.location);
                    }
                    Vector v1 = entity.getLocation().toVector();
                    Vector v2 = this.location.toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(speed.asDouble());
                    entity.setVelocity(v3);
                    if (!freeflight && Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        destinations.remove(0);
                    }
                } else {
                    this.flying = false;
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 3L);
    }
}

