/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class NarrateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments().size() > 4) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format")) {
                FormatScriptContainer format = null;
                String formatStr = arg.asElement().asString();
                format = ScriptRegistry.getScriptContainerAs(formatStr, FormatScriptContainer.class);
                if (format != null) {
                    dB.echoDebug("... format set to: " + formatStr);
                } else {
                    dB.echoError("... could not find format for: " + formatStr);
                }
                scriptEntry.addObject("format", format);
                continue;
            }
            if (arg.matchesPrefix("target") || arg.matchesPrefix("targets")) {
                scriptEntry.addObject("targets", ((dList)arg.asType(dList.class)).filter(dPlayer.class));
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", arg.asElement());
                continue;
            }
            dB.echoError("Unknown argument " + arg.raw_value);
        }
        if (!scriptEntry.hasObject("targets")) {
            scriptEntry.addObject("targets", scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer()) : null);
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List targets = (List)scriptEntry.getObject("targets");
        String text = scriptEntry.getElement("text").asString();
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        dB.report(this.getName(), aH.debugObj("Narrating", text) + aH.debugObj("Targets", targets) + (format != null ? aH.debugObj("Format", format.getName()) : ""));
        for (dPlayer player : targets) {
            if (player != null && player.isOnline()) {
                player.getPlayerEntity().sendMessage(format != null ? format.getFormattedText(scriptEntry) : text);
                continue;
            }
            dB.echoError("Narrated to non-existent or offline player!");
        }
    }
}

