/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.UUID;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.BracedCommand;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RepeatCommand
extends BracedCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (scriptEntry.hasObject("qty") || !arg.matchesPrimitive(aH.PrimitiveType.Integer)) continue;
            scriptEntry.addObject("qty", arg.asElement());
        }
        if (!scriptEntry.hasObject("qty")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "QUANTITY");
        }
        scriptEntry.addObject("entries", this.getBracedCommands(scriptEntry));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int qty = ((Element)scriptEntry.getObject("qty")).asInt();
        ArrayList entries = (ArrayList)scriptEntry.getObject("entries");
        dB.report(this.getName(), aH.debugObj("qty", qty));
        for (int incr = 0; incr < qty; ++incr) {
            ArrayList<ScriptEntry> newEntries = new ArrayList<ScriptEntry>();
            for (ScriptEntry entr : entries) {
                try {
                    ScriptEntry toadd = entr.clone();
                    toadd.getObjects().clear();
                    newEntries.add(toadd);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            InstantQueue queue = new InstantQueue(UUID.randomUUID().toString());
            scriptEntry.getResidingQueue().addContext("value", String.valueOf(incr + 1));
            queue.addContext("value", String.valueOf(incr + 1));
            queue.addEntries(newEntries);
            queue.start();
        }
    }
}

