/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.Anchors;
import org.bukkit.Location;

public class AnchorCommand
extends AbstractCommand {
    public static final String RANGE_ARG = "range, r";
    public static final String ID_ARG = "id, i";

    public String getHelp() {
        return "Controls NPCs' anchors. Anchors are 'bookmarked locations'stored at the NPC-level. Valid actions are Add, Remove, Assume Walk_To, and Walk_Near. \n \nUse to add or remove an anchor from a NPC. \n- anchor add i:pride_rock <npc.location> \n- anchor remove i:the_jungle \nUse to 'teleport' the npc directly to an existing anchor. \n- anchor assume i:bedroom \nUse to make a NPC navigate to or near an anchor for easy'waypoint behavior'. \n- anchor walkto i:anchor_1 \n- anchor walknear i:front_porch r:5";
    }

    public String getUsage() {
        return "- anchor [<action>] [id|i:id_name] ([<location>]) ([range|r:#])";
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("range") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix(RANGE_ARG)) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix(ID_ARG)) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            dB.echoError("Unhandled argument: '" + arg.raw_value + "'");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an 'Anchor Action'.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element range = (Element)scriptEntry.getObject("range");
        Element id = (Element)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj("NPC", scriptEntry.getNPC().toString()) + action.name() + id.debug() + (location != null ? location.debug() : "") + (range != null ? range.debug() : ""));
        dNPC npc = scriptEntry.getNPC();
        switch (action) {
            case ADD: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).addAnchor(id.asString(), (Location)location);
                return;
            }
            case ASSUME: {
                npc.getEntity().teleport(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString()).getLocation());
                return;
            }
            case WALKNEAR: {
                npc.getNavigator().setTarget(Utilities.getWalkableLocationNear(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString()).getLocation(), range.asInt()));
                return;
            }
            case WALKTO: {
                npc.getNavigator().setTarget(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString()).getLocation());
                return;
            }
            case REMOVE: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).removeAnchor(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME,
        WALKTO,
        WALKNEAR;

    }
}

