/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class ModifyBlockCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                dB.echoDebug("...location set to: " + scriptEntry.getObject("location"));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrefix("radius, r") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("radius", new Element(arg.getValue()));
                dB.echoDebug("...radius set to " + scriptEntry.getObject("radius"));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrefix("height, h") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("height", new Element(arg.getValue()));
                dB.echoDebug("...height set to " + scriptEntry.getObject("height"));
                continue;
            }
            if (!scriptEntry.hasObject("depth") && arg.matchesPrefix("depth, d") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("depth", new Element(arg.getValue()));
                dB.echoDebug("...depth set to " + scriptEntry.getObject("depth"));
                continue;
            }
            String value = arg.getValue().toUpperCase();
            if (value.split(":", 2).length > 1) {
                scriptEntry.addObject("data", aH.getIntegerFrom(value.split(":", 2)[1]));
            }
            if (aH.matchesInteger(value = value.split(":", 2)[0])) {
                scriptEntry.addObject("material", Material.getMaterial((int)aH.getIntegerFrom(value)));
            } else {
                scriptEntry.addObject("material", Material.getMaterial((String)value));
            }
            if (scriptEntry.getObject("material") != null) {
                dB.echoDebug("...material set to " + scriptEntry.getObject("material"));
                continue;
            }
            dB.echoDebug("...material not valid.");
        }
        if (!scriptEntry.hasObject("material")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "MATERIAL");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        scriptEntry.defaultObject("data", new Element(0));
        scriptEntry.defaultObject("radius", new Element(0));
        scriptEntry.defaultObject("height", new Element(0));
        scriptEntry.defaultObject("depth", new Element(0));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int y;
        Block currentBlock;
        int z;
        int x;
        Material material = (Material)scriptEntry.getObject("material");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        int data = scriptEntry.getElement("data").asInt();
        int radius = scriptEntry.getElement("radius").asInt();
        int height = scriptEntry.getElement("height").asInt();
        int depth = scriptEntry.getElement("depth").asInt();
        if (location == null || material == null) {
            dB.echoDebug("...can not exectue");
            return;
        }
        World world = location.getWorld();
        Block startBlock = location.getBlock();
        startBlock.setType(material);
        startBlock.setData((byte)data);
        if (radius != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY(), startBlock.getZ() + z - radius);
                    if (currentBlock.getType() == material) continue;
                    currentBlock.setType(material);
                    currentBlock.setData((byte)data);
                }
            }
        }
        if (height != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < height + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() + y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material) continue;
                        currentBlock.setType(material);
                        currentBlock.setData((byte)data);
                    }
                }
            }
        }
        if (depth != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < depth + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() - y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material) continue;
                        currentBlock.setType(material);
                        currentBlock.setData((byte)data);
                    }
                }
            }
        }
    }
}

