/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryType;

public class InventoryScriptContainer
extends ScriptContainer {
    public Map<String, dItem> definitions = new HashMap<String, dItem>();

    public InventoryScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public int getSize() {
        InventoryType invType = this.getInventoryType();
        Integer size = Integer.valueOf(this.getString("size"));
        if (size > 0 && invType == InventoryType.CHEST) {
            return Math.round(size / 9) * 9;
        }
        return invType.getDefaultSize();
    }

    public InventoryType getInventoryType() {
        String typeStr = this.getString("inventory", "chest");
        try {
            InventoryType type = InventoryType.valueOf((String)typeStr);
            return type;
        }
        catch (Exception e) {
            return InventoryType.CHEST;
        }
    }

    public dInventory getInventoryFrom() {
        return this.getInventoryFrom(null, null);
    }

    public dInventory getInventoryFrom(dPlayer player, dNPC npc) {
        dInventory inventory = null;
        try {
            if (this.contains("DEFINITIONS")) {
                // empty if block
            }
            if (this.contains("SLOTS")) {
                for (String items : this.getStringList("SLOTS")) {
                    items = TagManager.tag(player, npc, items);
                }
            }
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this inventory script!");
            if (!dB.showStackTraces) {
                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
            } else {
                e.printStackTrace();
            }
            inventory = null;
        }
        return inventory;
    }
}

