/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.notable.Note;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;

public class dInventory
implements dObject,
Notable {
    static final Pattern inventory_by_type = Pattern.compile("(in@)(npc|player|entity|location|equipment)(\\[)(.+?)(\\])", 2);
    static final Pattern inventory_by_saved = Pattern.compile("(in@)(.+)");
    String holderType = null;
    String holderIdentifier = null;
    private Inventory inventory = null;
    private String prefix = "Inventory";

    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Note(value="inventory")
    public String getSaveString() {
        return this.identify();
    }

    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    public void forget() {
        NotableManager.remove(this);
    }

    @ObjectFetcher(value="in")
    public static dInventory valueOf(String string) {
        if (string == null) {
            return null;
        }
        Matcher m = inventory_by_type.matcher(string);
        if (m.matches()) {
            String t = m.group(2);
            String h = m.group(4);
            if (t.equalsIgnoreCase("npc")) {
                if (dNPC.matches(h.startsWith("n@") ? h : "n@" + h) && (dNPC.valueOf(h.startsWith("n@") ? h : "n@" + h).getEntity() instanceof Player || dNPC.valueOf(h.startsWith("n@") ? h : "n@" + h).getEntity() instanceof Horse)) {
                    return new dInventory(dNPC.valueOf(h).getEntity());
                }
            } else if (t.equalsIgnoreCase("player")) {
                if (dPlayer.matches(h)) {
                    return new dInventory(dPlayer.valueOf(h).getPlayerEntity());
                }
            } else if (t.equalsIgnoreCase("entity")) {
                if (dEntity.matches(h.startsWith("e@") ? h : "e@" + h) && dEntity.valueOf(h.startsWith("e@") ? h : "e@" + h).isLivingEntity()) {
                    return new dInventory(dEntity.valueOf(h.startsWith("e@") ? h : "e@" + h).getLivingEntity());
                }
            } else if (t.equalsIgnoreCase("location")) {
                BlockState block;
                if (dLocation.matches(h) && (block = dLocation.valueOf(h).getBlock().getState()) instanceof InventoryHolder) {
                    return new dInventory(block);
                }
            } else if (t.equalsIgnoreCase("equipment")) {
                if (dNPC.matches(h)) {
                    if (CitizensAPI.getNPCRegistry().getById(Integer.valueOf(h.substring(2)).intValue()) instanceof Player) {
                        return new dInventory(InventoryType.CRAFTING, t, h).add(CitizensAPI.getNPCRegistry().getById(Integer.valueOf(h.substring(2)).intValue()).getBukkitEntity().getEquipment().getArmorContents());
                    }
                } else {
                    if (dPlayer.matches(h) && Bukkit.getPlayer((String)h.substring(2)).isOnline()) {
                        return new dInventory(InventoryType.CRAFTING, t, h).add(Bukkit.getPlayer((String)h.substring(2)).getEquipment().getArmorContents());
                    }
                    if (dEntity.matches(h) && dEntity.valueOf(h).isLivingEntity() && dEntity.valueOf(h).isSpawned()) {
                        return new dInventory(InventoryType.CRAFTING, t, h).add(dEntity.valueOf(h).getLivingEntity().getEquipment().getArmorContents());
                    }
                }
            }
            dB.echoError("Value of dInventory returning null. Invalid " + t + " specified: " + h);
            return null;
        }
        m = inventory_by_saved.matcher(string);
        if (m.matches()) {
            if (NotableManager.isType(m.group(2), dInventory.class)) {
                return (dInventory)NotableManager.getSavedObject(m.group(2));
            }
            dB.echoError("Value of dInventory returning null. Invalid notable specified: " + m.group(2));
            return null;
        }
        dB.echoError("Value of dInventory returning null. Invalid dInventory specified: " + string);
        return null;
    }

    public static boolean matches(String arg) {
        return dInventory.valueOf(arg) != null;
    }

    public dInventory(Inventory inventory) {
        if (inventory.getHolder() != null) {
            InventoryHolder holder = inventory.getHolder();
            if (!(holder instanceof LivingEntity)) {
                if (holder instanceof DoubleChest) {
                    this.holderIdentifier = ((DoubleChest)holder).getLocation().toString();
                } else if (holder instanceof BlockState) {
                    this.holderIdentifier = ((BlockState)holder).getLocation().toString();
                }
                this.holderType = "location";
            } else if (holder instanceof Player) {
                if (CitizensAPI.getNPCRegistry().isNPC((Entity)((LivingEntity)holder))) {
                    this.holderType = "npc";
                    this.holderIdentifier = String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)((LivingEntity)holder)).getId());
                } else {
                    this.holderType = "player";
                    this.holderIdentifier = ((Player)holder).getName();
                }
            } else if (holder instanceof Horse) {
                this.holderType = "entity";
                this.holderIdentifier = String.valueOf(((Horse)holder).getEntityId());
            } else if (holder instanceof HopperMinecart) {
                this.holderType = "entity";
                this.holderIdentifier = String.valueOf(((HopperMinecart)holder).getEntityId());
            } else if (holder instanceof StorageMinecart) {
                this.holderType = "entity";
                this.holderIdentifier = String.valueOf(((StorageMinecart)holder).getEntityId());
            } else {
                if (CitizensAPI.getNPCRegistry().isNPC((Entity)((LivingEntity)holder))) {
                    dB.echoError("Only Player-type NPCs can have inventories.");
                    return;
                }
                this.holderType = "entity";
                this.holderIdentifier = String.valueOf(((LivingEntity)holder).getEntityId());
            }
        }
        this.inventory = inventory;
    }

    public dInventory(InventoryType type) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
    }

    public dInventory(InventoryType type, String id, String identifier) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
        this.holderType = id;
        this.holderIdentifier = identifier;
    }

    public dInventory(InventoryHolder holder) {
        if (!(holder instanceof LivingEntity)) {
            if (holder instanceof DoubleChest) {
                this.holderIdentifier = ((DoubleChest)holder).getLocation().toString();
            } else if (holder instanceof BlockState) {
                this.holderIdentifier = ((BlockState)holder).getLocation().toString();
            }
            this.holderType = "location";
        } else if (holder instanceof Player) {
            if (CitizensAPI.getNPCRegistry().isNPC((Entity)((LivingEntity)holder))) {
                this.holderType = "npc";
                this.holderIdentifier = String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)((LivingEntity)holder)).getId());
            } else {
                this.holderType = "player";
                this.holderIdentifier = ((Player)holder).getName();
            }
        } else if (holder instanceof Horse) {
            this.holderType = "entity";
            this.holderIdentifier = String.valueOf(((Horse)holder).getEntityId());
        } else if (holder instanceof HopperMinecart) {
            this.holderType = "entity";
            this.holderIdentifier = String.valueOf(((HopperMinecart)holder).getEntityId());
        } else if (holder instanceof StorageMinecart) {
            this.holderType = "entity";
            this.holderIdentifier = String.valueOf(((StorageMinecart)holder).getEntityId());
        } else {
            if (CitizensAPI.getNPCRegistry().isNPC((Entity)((LivingEntity)holder))) {
                dB.echoError("Only Player-type NPCs can have inventories.");
                return;
            }
            this.holderType = "entity";
            this.holderIdentifier = String.valueOf(((LivingEntity)holder).getEntityId());
        }
    }

    public dInventory(Player player) {
        this.inventory = player.getInventory();
        this.holderType = "player";
        this.holderIdentifier = player.getName();
    }

    public dInventory(BlockState state) {
        if (state instanceof InventoryHolder) {
            this.inventory = ((InventoryHolder)state).getInventory();
            this.holderType = "location";
            this.holderIdentifier = state.getLocation().toString();
        }
    }

    public dInventory(LivingEntity entity) {
        if (entity instanceof InventoryHolder) {
            this.inventory = ((InventoryHolder)entity).getInventory();
            this.holderType = "entity";
            this.holderIdentifier = String.valueOf(entity.getEntityId());
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public dInventory add(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.addItem(new ItemStack[]{item});
        }
        return this;
    }

    public int count(ItemStack item, boolean stacks) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || item != null && !invStack.isSimilar(item)) continue;
            if (stacks) {
                ++qty;
                continue;
            }
            qty += invStack.getAmount();
        }
        return qty;
    }

    public dInventory keep(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack invStack : this.inventory) {
            if (invStack == null) continue;
            boolean keep = false;
            for (ItemStack item : items) {
                if (!invStack.isSimilar(item)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.remove(invStack);
        }
        return this;
    }

    public dInventory exclude(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.remove(items).count(null, false);
        }
        return this;
    }

    public dInventory fill(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.add(items).count(null, false);
        }
        return this;
    }

    public dLocation getLocation() {
        if (this.inventory != null) {
            InventoryHolder holder = this.inventory.getHolder();
            if (holder instanceof BlockState) {
                return new dLocation(((BlockState)holder).getLocation());
            }
            if (holder instanceof Player) {
                return new dLocation(((Player)holder).getLocation());
            }
        }
        return null;
    }

    public dInventory remove(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.removeItem(new ItemStack[]{item});
        }
        return this;
    }

    public dInventory removeBook(ItemStack book) {
        if (this.inventory == null || book == null) {
            return this;
        }
        int qty = book.getAmount();
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        for (ItemStack invStack : this.inventory) {
            BookMeta invMeta;
            if (qty == 0) break;
            if (invStack == null || !(invStack.getItemMeta() instanceof BookMeta) || !(invMeta = (BookMeta)invStack.getItemMeta()).getAuthor().equalsIgnoreCase(bookMeta.getAuthor()) || !invMeta.getTitle().equalsIgnoreCase(bookMeta.getTitle())) continue;
            if (qty - invStack.getAmount() < 0) {
                invStack.setAmount((qty - invStack.getAmount()) * -1);
                continue;
            }
            this.inventory.removeItem(new ItemStack[]{invStack});
            qty -= invStack.getAmount();
        }
        return this;
    }

    public void replace(dInventory destination) {
        if (this.inventory == null || destination == null) {
            return;
        }
        if (destination.getSize() < this.getSize()) {
            destination.clear();
            destination.add(this.getContents());
        } else {
            destination.setContents(this.getContents());
        }
    }

    public void clear() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    public ItemStack[] getContents() {
        if (this.inventory != null) {
            return this.inventory.getContents();
        }
        return new ItemStack[0];
    }

    public InventoryType getInventoryType() {
        return this.inventory.getType();
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void remove(ItemStack item) {
        this.inventory.remove(item);
    }

    public void setContents(ItemStack[] contents) {
        this.inventory.setContents(contents);
    }

    public String getType() {
        return "Inventory";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dInventory setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return null;
    }

    public String identify() {
        return "in@" + (this.holderType.equals("notable") ? this.holderIdentifier : this.holderType + "[" + this.holderIdentifier + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            int qty = 1;
            if (!attribute.getAttribute(2).startsWith("qty") || !attribute.hasContext(2) || !aH.matchesInteger(attribute.getContext(2))) return new Element(this.getInventory().containsAtLeast(dItem.valueOf(attribute.getContext(1)).getItemStack(), qty)).getAttribute(attribute.fulfill(qty == 1 ? 1 : 2));
            qty = attribute.getIntContext(2);
            return new Element(this.getInventory().containsAtLeast(dItem.valueOf(attribute.getContext(1)).getItemStack(), qty)).getAttribute(attribute.fulfill(qty == 1 ? 1 : 2));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("qty")) {
            if (!attribute.hasContext(1) || !dItem.matches(attribute.getContext(1))) return new Element(String.valueOf(this.count(null, false))).getAttribute(attribute.fulfill(1));
            return new Element(String.valueOf(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), false))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("size")) {
            return new Element(String.valueOf(this.getSize())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("stacks")) {
            if (!attribute.hasContext(1) || !dItem.matches(attribute.getContext(1))) return new Element(String.valueOf(this.count(null, true))).getAttribute(attribute.fulfill(1));
            return new Element(String.valueOf(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), true))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element(this.getInventory().getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equipment")) {
            if (this.getInventory() instanceof PlayerInventory) {
                String identifier = null;
                if (CitizensAPI.getNPCRegistry().isNPC((Entity)((LivingEntity)this.getInventory().getHolder()))) {
                    if (!(this.inventory.getHolder() instanceof Player)) return new Element("null").getAttribute(attribute.fulfill(1));
                    identifier = "n@" + CitizensAPI.getNPCRegistry().getNPC((Entity)((LivingEntity)this.getInventory().getHolder())).getId();
                    return new dInventory(InventoryType.CRAFTING, "equipment", identifier).add(((PlayerInventory)this.getInventory()).getArmorContents()).getAttribute(attribute.fulfill(1));
                } else if (this.inventory.getHolder() instanceof Player) {
                    identifier = "p@" + ((Player)this.getInventory().getHolder()).getName();
                    return new dInventory(InventoryType.CRAFTING, "equipment", identifier).add(((PlayerInventory)this.getInventory()).getArmorContents()).getAttribute(attribute.fulfill(1));
                } else {
                    if (!(this.inventory.getHolder() instanceof LivingEntity)) return new Element("null").getAttribute(attribute.fulfill(1));
                    identifier = "e@" + ((Player)this.getInventory().getHolder()).getEntityId();
                }
                return new dInventory(InventoryType.CRAFTING, "equipment", identifier).add(((PlayerInventory)this.getInventory()).getArmorContents()).getAttribute(attribute.fulfill(1));
            }
            if (this.getInventory() instanceof HorseInventory) {
                return new dInventory(InventoryType.CRAFTING, "equipment", this.getInventory().getHolder() != null ? "e@" + String.valueOf(((LivingEntity)this.getInventory().getHolder()).getEntityId()) : this.getInventory().getName()).getAttribute(attribute.fulfill(1));
            }
        }
        if (!attribute.startsWith("list_contents")) return new Element(this.identify()).getAttribute(attribute.fulfill(0));
        ArrayList<dItem> items = new ArrayList<dItem>();
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(new dItem(item));
        }
        return new dList(items).getAttribute(attribute.fulfill(1));
    }
}

