/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dWorld
implements dObject {
    static Map<String, dWorld> worlds = new HashMap<String, dWorld>();
    private String prefix;
    String world_name;

    public static dWorld mirrorBukkitWorld(World world) {
        if (worlds.containsKey(world.getName())) {
            return worlds.get(world.getName());
        }
        return new dWorld(world);
    }

    @ObjectFetcher(value="w")
    public static dWorld valueOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            if (worlds.containsKey(returnable.getName())) {
                return worlds.get(returnable.getName());
            }
            return new dWorld(returnable);
        }
        dB.echoError("Invalid World! '" + string + "' could not be found.");
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public dWorld(World world) {
        this(null, world);
    }

    public dWorld(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
        if (!worlds.containsKey(world.getName())) {
            worlds.put(world.getName(), this);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getType() {
        return "World";
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("can_generate_structures")) {
            return new Element(String.valueOf(this.getWorld().canGenerateStructures())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("highest_block")) {
            int x = 1;
            int z = 1;
            return new dLocation(this.getWorld().getHighestBlockAt(x, z).getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("difficulty")) {
            return new Element(this.getWorld().getDifficulty().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(String.valueOf(this.getWorld().getName())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("players")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : this.getWorld().getPlayers()) {
                players.add(player.getName());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sea_level")) {
            return new Element(String.valueOf(this.getWorld().getSeaLevel())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("seed")) {
            return new Element(String.valueOf(this.getWorld().getSeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time.period")) {
            long time = this.getWorld().getTime();
            String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
            return new Element(period).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("time")) {
            return new Element(String.valueOf(this.getWorld().getTime())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather_duration")) {
            return Duration.valueOf(String.valueOf(this.getWorld().getWeatherDuration()) + "t").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_storm")) {
            return new Element(String.valueOf(this.getWorld().hasStorm())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }
}

