/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ProcedureScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRegistry {
    private static Map<String, Object> scriptContainers = new HashMap<String, Object>();
    private static Map<String, Class<? extends ScriptContainer>> scriptContainerTypes = new HashMap<String, Class<? extends ScriptContainer>>();
    public static List<FileConfiguration> outside_scripts = new ArrayList<FileConfiguration>();

    public static void _registerType(String typeName, Class<? extends ScriptContainer> scriptContainerClass) {
        scriptContainerTypes.put(typeName.toUpperCase(), scriptContainerClass);
    }

    public static Set<String> _getScriptNames() {
        return scriptContainers.keySet();
    }

    public static void _registerCoreTypes() {
        ScriptRegistry._registerType("interact", InteractScriptContainer.class);
        ScriptRegistry._registerType("book", BookScriptContainer.class);
        ScriptRegistry._registerType("item", ItemScriptContainer.class);
        ScriptRegistry._registerType("entity", EntityScriptContainer.class);
        ScriptRegistry._registerType("task", TaskScriptContainer.class);
        ScriptRegistry._registerType("assignment", AssignmentScriptContainer.class);
        ScriptRegistry._registerType("procedure", ProcedureScriptContainer.class);
        ScriptRegistry._registerType("world", WorldScriptContainer.class);
        ScriptRegistry._registerType("format", FormatScriptContainer.class);
        ScriptRegistry._registerType("inventory", InventoryScriptContainer.class);
    }

    public static boolean containsScript(String id) {
        return scriptContainers.containsKey(id.toUpperCase());
    }

    public static boolean containsScript(String id, Class scriptContainerType) {
        if (!scriptContainers.containsKey(id.toUpperCase())) {
            return false;
        }
        ScriptContainer script = (ScriptContainer)scriptContainers.get(id.toUpperCase());
        String type = null;
        for (Map.Entry<String, Class<? extends ScriptContainer>> entry : scriptContainerTypes.entrySet()) {
            if (entry.getValue() != scriptContainerType) continue;
            type = entry.getKey();
        }
        return type != null && script.getType().equalsIgnoreCase(type);
    }

    public static void _buildCoreYamlScriptContainers(FileConfiguration yamlScripts) {
        Set scripts = yamlScripts.getKeys(false);
        for (String scriptName : scripts) {
            if (!yamlScripts.contains(scriptName + ".TYPE")) continue;
            String type = yamlScripts.getString(scriptName + ".TYPE");
            if (!scriptContainerTypes.containsKey(type.toUpperCase())) {
                dB.log("<G>Trying to load an invalid script. '<A>" + scriptName + "<Y>(" + type + ")'<G> is an unknown type.");
                continue;
            }
            Class<? extends ScriptContainer> typeClass = scriptContainerTypes.get(type.toUpperCase());
            try {
                scriptContainers.put(scriptName, typeClass.getConstructor(ConfigurationSection.class, String.class).newInstance(ScriptHelper._gs().getConfigurationSection(scriptName), scriptName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addYamlScriptContainer(FileConfiguration yaml_script) {
        outside_scripts.add(yaml_script);
        ScriptHelper.reloadScripts();
    }

    public static void removeYamlScriptContainer(FileConfiguration yaml_script) {
        outside_scripts.remove(yaml_script);
        ScriptHelper.reloadScripts();
    }

    public static <T extends ScriptContainer> T getScriptContainerAs(String name, Class<T> type) {
        try {
            if (scriptContainers.containsKey(name.toUpperCase())) {
                return (T)((ScriptContainer)type.cast(scriptContainers.get(name.toUpperCase())));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ScriptContainer getScriptContainer(String name) {
        if (scriptContainers.containsKey(name.toUpperCase())) {
            return (ScriptContainer)scriptContainers.get(name.toUpperCase());
        }
        return null;
    }
}

