/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.npc.ai.BlockBreaker;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class BreakCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entity", arg.asType(dEntity.class));
                continue;
            }
            if (scriptEntry.hasObject("radius") || !arg.matchesPrimitive(aH.PrimitiveType.Double)) continue;
            scriptEntry.addObject("radius", arg.asElement());
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("entity")) {
            if (scriptEntry.getPlayer() != null && scriptEntry.getPlayer().isOnline()) {
                scriptEntry.addObject("entity", new dEntity((Entity)scriptEntry.getPlayer().getPlayerEntity()));
            } else if (scriptEntry.getNPC() != null && scriptEntry.getNPC().isSpawned()) {
                scriptEntry.addObject("entity", new dEntity((Entity)scriptEntry.getNPC().getEntity()));
            } else {
                throw new InvalidArgumentsException("Must specify an entity!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        final dLocation location = (dLocation)scriptEntry.getObject("location");
        final dEntity entity = (dEntity)scriptEntry.getObject("entity");
        Element radius = scriptEntry.hasObject("radius") ? (Element)scriptEntry.getObject("radius") : null;
        dB.report(this.getName(), location.debug() + entity.debug() + (radius != null ? radius.debug() : ""));
        BlockBreaker.Configuration config = new BlockBreaker.Configuration().item(entity.getLivingEntity().getEquipment().getItemInHand()).radius(radius != null ? radius.asDouble() : 1.0).callback(new Runnable(){

            public void run() {
                dB.echoDebug(entity.debug() + " dug " + location.debug());
            }
        });
        BlockBreaker breaker = BlockBreaker.createWithConfiguration((LivingEntity)entity.getLivingEntity(), (Block)location.getBlock(), (BlockBreaker.Configuration)config);
        breaker.run();
    }
}

