/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.Velocity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Gravity;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("physics") && arg.matchesEnum(PhysicsType.values())) {
                scriptEntry.addObject("physics", (Object)PhysicsType.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin, o, source, shooter, s")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (!arg.matchesArgumentType(dLocation.class)) continue;
                scriptEntry.addObject("originLocation", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("speed, s")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("height, h")) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("gravity") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("gravity, g")) {
                scriptEntry.addObject("gravity", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("script") || !arg.matchesArgumentType(dScript.class)) continue;
            scriptEntry.addObject("script", arg.asType(dScript.class));
        }
        if (!scriptEntry.hasObject("originLocation")) {
            scriptEntry.defaultObject("originEntity", scriptEntry.hasNPC() ? scriptEntry.getNPC().getDenizenEntity() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("speed", new Element(1.5));
        scriptEntry.defaultObject("duration", Duration.valueOf("80t"));
        scriptEntry.defaultObject("physics", new Object[]{PhysicsType.CALCULATED});
        scriptEntry.defaultObject("height", new Element(3));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "entities");
        }
        if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "origin");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation destination;
        LivingEntity shooter;
        PhysicsType physicsType = (PhysicsType)((Object)scriptEntry.getObject("physics"));
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = scriptEntry.hasObject("originLocation") ? (dLocation)scriptEntry.getObject("originLocation") : new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0));
        LivingEntity livingEntity = shooter = originEntity != null && originEntity.isLivingEntity() ? originEntity.getLivingEntity() : null;
        dLocation dLocation2 = scriptEntry.hasObject("destination") ? (dLocation)scriptEntry.getObject("destination") : (destination = shooter != null ? new dLocation(shooter.getEyeLocation().add(shooter.getEyeLocation().getDirection().multiply(30))) : null);
        if (destination == null) {
            dB.report(this.getName(), "No destination specified!");
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        final dScript script = (dScript)scriptEntry.getObject("script");
        final double speed = ((Element)scriptEntry.getObject("speed")).asDouble();
        final int maxRuns = ((Duration)scriptEntry.getObject("duration")).getTicksAsInt() / 2;
        double height = ((Element)scriptEntry.getObject("height")).asDouble();
        Element gravity = (Element)scriptEntry.getObject("gravity");
        dB.report(this.getName(), aH.debugObj("origin", originEntity != null ? originEntity : originLocation) + aH.debugObj("entities", entities.toString()) + aH.debugObj("destination", destination) + (physicsType.equals((Object)PhysicsType.CALCULATED) ? aH.debugObj("height", height) + (scriptEntry.hasObject("gravity") ? aH.debugObj("gravity", gravity) : "default") : "") + (physicsType.equals((Object)PhysicsType.CUSTOM) ? aH.debugObj("speed", speed) + aH.debugObj("duration", new Duration(maxRuns * 2)) : "") + (script != null ? aH.debugObj("script", script) : ""));
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) {
                entity.spawnAt(originLocation);
            } else {
                entity.teleport(originLocation);
            }
            Rotation.faceLocation(entity.getBukkitEntity(), destination);
            if (!(entity.getBukkitEntity() instanceof Projectile) || shooter == null) continue;
            ((Projectile)entity.getBukkitEntity()).setShooter(shooter);
        }
        Position.mount(Conversion.convert(entities));
        final Entity lastEntity = ((dEntity)entities.get(entities.size() - 1)).getBukkitEntity();
        if (physicsType.equals((Object)PhysicsType.CALCULATED)) {
            if (gravity == null) {
                String entityType = lastEntity.getType().name();
                for (Gravity defaultGravity : Gravity.values()) {
                    if (!defaultGravity.name().equals(entityType)) continue;
                    gravity = new Element(defaultGravity.getGravity());
                    dB.echoApproval("Gravity: " + gravity);
                }
                if (gravity == null) {
                    gravity = new Element(0.115);
                }
            }
            Vector v1 = lastEntity.getLocation().toVector();
            Vector v2 = destination.toVector();
            Vector v3 = Velocity.calculate(v1, v2, gravity.asDouble(), height);
            lastEntity.setVelocity(v3);
        } else if (physicsType.equals((Object)PhysicsType.CUSTOM)) {
            BukkitRunnable task = new BukkitRunnable(){
                int runs = 0;

                public void run() {
                    if (this.runs < maxRuns && lastEntity.isValid()) {
                        Vector v1 = lastEntity.getLocation().toVector();
                        Vector v2 = destination.toVector();
                        Vector v3 = v2.clone().subtract(v1).normalize().multiply(speed);
                        lastEntity.setVelocity(v3);
                        ++this.runs;
                        if (Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                            this.runs = maxRuns;
                        }
                        if (!lastEntity.getLocation().add(v3).getBlock().getType().toString().equals("AIR")) {
                            this.runs = maxRuns;
                        }
                    } else {
                        this.cancel();
                        this.runs = 0;
                        if (script != null) {
                            HashMap<String, String> context = new HashMap<String, String>();
                            context.put("1", lastEntity.getLocation().getX() + "," + lastEntity.getLocation().getY() + "," + lastEntity.getLocation().getZ() + "," + lastEntity.getLocation().getWorld().getName());
                            context.put("2", "e@" + lastEntity.getEntityId());
                            ((TaskScriptContainer)script.getContainer()).setSpeed(new Duration(0)).runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
                        }
                    }
                }
            };
            task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PhysicsType {
        CALCULATED,
        CUSTOM;

    }
}

