/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class DetermineCommand
extends AbstractCommand {
    private static Map<Long, String> outcomes = new ConcurrentHashMap<Long, String>(8, 0.9f, 1);
    public static long uniqueId = 0L;

    public static long getNewId() {
        return ++uniqueId;
    }

    public static boolean hasOutcome(long id) {
        return outcomes.containsKey(id);
    }

    public static String getOutcome(long id) {
        String outcome = outcomes.get(id);
        outcomes.remove(id);
        return outcome;
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("passive, passively")) {
                scriptEntry.addObject("passively", new Element(true));
                continue;
            }
            scriptEntry.addObject("outcome", arg.asElement());
        }
        scriptEntry.defaultObject("passively", new Element(false));
        scriptEntry.defaultObject("outcome", new Element(false));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.report(this.getName(), scriptEntry.getElement("outcome").debug() + scriptEntry.getElement("passively").debug());
        String outcome = scriptEntry.getElement("outcome").asString();
        Boolean passively = scriptEntry.getElement("passively").asBoolean();
        Long uniqueId = (Long)scriptEntry.getObject("reqId");
        if (uniqueId == null) {
            return;
        }
        outcomes.put(uniqueId, outcome);
        if (!passively.booleanValue()) {
            scriptEntry.getResidingQueue().clear();
        }
    }
}

