/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.Velocity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Gravity;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin, o, source, shooter, s")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (!arg.matchesArgumentType(dLocation.class)) continue;
                scriptEntry.addObject("originLocation", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("height, h")) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("gravity") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("gravity, g")) {
                scriptEntry.addObject("gravity", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("script") || !arg.matchesArgumentType(dScript.class)) continue;
            scriptEntry.addObject("script", arg.asType(dScript.class));
        }
        if (!scriptEntry.hasObject("originLocation")) {
            scriptEntry.defaultObject("originEntity", scriptEntry.hasNPC() ? scriptEntry.getNPC().getDenizenEntity() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("height", new Element(3));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "entities");
        }
        if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "origin");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation destination;
        LivingEntity shooter;
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = scriptEntry.hasObject("originLocation") ? (dLocation)scriptEntry.getObject("originLocation") : new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0));
        LivingEntity livingEntity = shooter = originEntity != null && originEntity.isLivingEntity() ? originEntity.getLivingEntity() : null;
        dLocation dLocation2 = scriptEntry.hasObject("destination") ? (dLocation)scriptEntry.getObject("destination") : (destination = shooter != null ? new dLocation(shooter.getEyeLocation().add(shooter.getEyeLocation().getDirection().multiply(30))) : null);
        if (destination == null) {
            dB.report(this.getName(), "No destination specified!");
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        final dScript script = (dScript)scriptEntry.getObject("script");
        double height = ((Element)scriptEntry.getObject("height")).asDouble();
        Element gravity = (Element)scriptEntry.getObject("gravity");
        dB.report(this.getName(), aH.debugObj("origin", originEntity != null ? originEntity : originLocation) + aH.debugObj("entities", entities.toString()) + aH.debugObj("destination", destination) + aH.debugObj("height", height) + aH.debugObj("gravity", gravity) + (script != null ? aH.debugObj("script", script.identify()) : ""));
        final dList entityList = new dList();
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) {
                entity.spawnAt(originLocation);
            } else {
                entity.teleport(originLocation);
            }
            entityList.add(entity.toString());
            Rotation.faceLocation(entity.getBukkitEntity(), destination);
            if (!(entity.getBukkitEntity() instanceof Projectile) || shooter == null) continue;
            ((Projectile)entity.getBukkitEntity()).setShooter(shooter);
        }
        scriptEntry.addObject("shot_entities", entityList);
        Position.mount(Conversion.convert(entities));
        final dEntity lastEntity = (dEntity)entities.get(entities.size() - 1);
        if (gravity == null) {
            String entityType = lastEntity.getEntityType().name();
            for (Gravity defaultGravity : Gravity.values()) {
                if (!defaultGravity.name().equals(entityType)) continue;
                gravity = new Element(defaultGravity.getGravity());
                dB.echoApproval("Gravity: " + gravity);
            }
            if (gravity == null) {
                gravity = new Element(0.115);
            }
        }
        Vector v1 = lastEntity.getLocation().toVector();
        Vector v2 = destination.toVector();
        Vector v3 = Velocity.calculate(v1, v2, gravity.asDouble(), height);
        lastEntity.setVelocity(v3);
        BukkitRunnable task = new BukkitRunnable(){
            boolean flying = true;
            Vector lastVelocity = null;

            public void run() {
                if (!lastEntity.isValid()) {
                    this.flying = false;
                } else if (this.lastVelocity != null && this.lastVelocity.distance(lastEntity.getBukkitEntity().getVelocity()) < 0.05) {
                    this.flying = false;
                }
                if (!this.flying) {
                    this.cancel();
                    List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.getPlayer(), scriptEntry.getNPC());
                    ScriptQueue queue = InstantQueue.getQueue(ScriptQueue._getNextId()).addEntries(entries);
                    queue.addDefinition("location", lastEntity.getLocation().identify());
                    queue.addDefinition("shot_entities", entityList.toString());
                    queue.addDefinition("last_entity", lastEntity.identify());
                    queue.start();
                } else {
                    this.lastVelocity = lastEntity.getVelocity();
                }
            }
        };
        if (script != null) {
            task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
        }
    }
}

