/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.World;
import org.bukkit.block.Block;

public class ModifyBlockCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                dB.echoDebug("...location set to: " + scriptEntry.getObject("location"));
                continue;
            }
            if (!scriptEntry.hasObject("material") && arg.matchesArgumentType(dMaterial.class)) {
                scriptEntry.addObject("material", arg.asType(dMaterial.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrefix("radius, r") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("radius", new Element(arg.getValue()));
                dB.echoDebug("...radius set to " + scriptEntry.getObject("radius"));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrefix("height, h") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("height", new Element(arg.getValue()));
                dB.echoDebug("...height set to " + scriptEntry.getObject("height"));
                continue;
            }
            if (scriptEntry.hasObject("depth") || !arg.matchesPrefix("depth, d") || !arg.matchesPrimitive(aH.PrimitiveType.Integer)) continue;
            scriptEntry.addObject("depth", new Element(arg.getValue()));
            dB.echoDebug("...depth set to " + scriptEntry.getObject("depth"));
        }
        if (!scriptEntry.hasObject("material")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "MATERIAL");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        scriptEntry.defaultObject("radius", new Element(0));
        scriptEntry.defaultObject("height", new Element(0));
        scriptEntry.defaultObject("depth", new Element(0));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int y;
        Block currentBlock;
        int z;
        int x;
        dMaterial material = (dMaterial)scriptEntry.getObject("material");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        int radius = scriptEntry.getElement("radius").asInt();
        int height = scriptEntry.getElement("height").asInt();
        int depth = scriptEntry.getElement("depth").asInt();
        if (location == null || material == null) {
            dB.echoDebug("...can not exectue");
            return;
        }
        World world = location.getWorld();
        Block startBlock = location.getBlock();
        startBlock.setType(material.getMaterial());
        if (material.hasData()) {
            startBlock.setData(material.getData().byteValue());
        }
        if (radius != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY(), startBlock.getZ() + z - radius);
                    if (currentBlock.getType() == material.getMaterial()) continue;
                    currentBlock.setType(material.getMaterial());
                    if (!material.hasData()) continue;
                    currentBlock.setData(material.getData().byteValue());
                }
            }
        }
        if (height != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < height + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() + y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material.getMaterial()) continue;
                        currentBlock.setType(material.getMaterial());
                        if (!material.hasData()) continue;
                        currentBlock.setData(material.getData().byteValue());
                    }
                }
            }
        }
        if (depth != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < depth + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() - y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material.getMaterial()) continue;
                        currentBlock.setType(material.getMaterial());
                        if (!material.hasData()) continue;
                        currentBlock.setData(material.getData().byteValue());
                    }
                }
            }
        }
    }
}

