/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.notable.Note;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dCuboid
implements dObject,
Notable {
    dLocation loc_1;
    dLocation loc_2;
    int x_distance;
    int y_distance;
    int z_distance;
    ArrayList<dObject> filter = new ArrayList();
    String prefix = "Cuboid";

    @ObjectFetcher(value="cu")
    public static dCuboid valueOf(String string) {
        if (string == null) {
            return null;
        }
        String[] positions = string.replace("cu@", "").split("\\|");
        dB.echoDebug(Arrays.asList(positions).toString());
        if (dLocation.matches(positions[0]) && dLocation.matches(positions[1])) {
            dLocation pos_1 = dLocation.valueOf(positions[0]);
            dLocation pos_2 = dLocation.valueOf(positions[1]);
            if (pos_1 == null || pos_2 == null) {
                dB.echoError("valueOf in dCuboid returning null: '" + string + "'.");
                return null;
            }
            if (pos_1.getWorld() != pos_2.getWorld()) {
                dB.echoError("Worlds must match on cuboid construction.");
                return null;
            }
            return new dCuboid(pos_1, pos_2);
        }
        Pattern item_by_saved = Pattern.compile("(cu@)(.+)");
        Matcher m = item_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return (dCuboid)NotableManager.getSavedObject(m.group(2));
        }
        dB.echoError("valueOf dCuboid returning null: " + string);
        return null;
    }

    public static boolean matches(String string) {
        Pattern location_by_saved = Pattern.compile("(cu@)(.+)");
        Pattern location = Pattern.compile("((-?\\d+,){3})\\w+\\|((-?\\d+,){3})\\w+", 2);
        Matcher m = location_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return true;
        }
        m = location.matcher(string.replace("cu@", ""));
        return m.matches();
    }

    private dCuboid(Location point_1, Location point_2) {
        World world = point_1.getWorld();
        int x_high = point_1.getBlockX() >= point_2.getBlockX() ? point_1.getBlockX() : point_2.getBlockX();
        int x_low = point_1.getBlockX() <= point_2.getBlockX() ? point_1.getBlockX() : point_2.getBlockX();
        this.x_distance = x_high - x_low;
        int y_high = point_1.getBlockY() >= point_2.getBlockY() ? point_1.getBlockY() : point_2.getBlockY();
        int y_low = point_1.getBlockY() <= point_2.getBlockY() ? point_1.getBlockY() : point_2.getBlockY();
        this.y_distance = y_high - y_low;
        int z_high = point_1.getBlockZ() >= point_2.getBlockZ() ? point_1.getBlockZ() : point_2.getBlockZ();
        int z_low = point_1.getBlockZ() <= point_2.getBlockZ() ? point_1.getBlockZ() : point_2.getBlockZ();
        this.z_distance = z_high - z_low;
        this.loc_1 = new dLocation(world, x_low, y_low, z_low);
        this.loc_2 = new dLocation(world, x_high, y_high, z_high);
    }

    public boolean isInsideCuboid(Location location) {
        if (location.getWorld() != this.loc_1.getWorld()) {
            return false;
        }
        if (!Utilities.isBetween(this.loc_1.getX(), this.loc_2.getX(), location.getX())) {
            return false;
        }
        if (!Utilities.isBetween(this.loc_1.getY(), this.loc_2.getY(), location.getY())) {
            return false;
        }
        return Utilities.isBetween(this.loc_1.getZ(), this.loc_2.getZ(), location.getZ());
    }

    public dCuboid addBlocksToFilter(List<dMaterial> addl) {
        this.filter.addAll(addl);
        return this;
    }

    public dCuboid removeBlocksFromFilter(List<dMaterial> addl) {
        this.filter.removeAll(addl);
        return this;
    }

    public dCuboid removeFilter() {
        this.filter.clear();
        return this;
    }

    public dCuboid setAsFilter(List<dMaterial> list) {
        this.filter.clear();
        this.filter.addAll(list);
        return this;
    }

    public dList getOutline() {
        dList list = new dList("");
        for (int y = this.loc_1.getBlockY(); y <= this.loc_1.getBlockY() + this.y_distance; ++y) {
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_1.getBlockX(), y, this.loc_1.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_2.getBlockX(), y, this.loc_2.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_1.getBlockX(), y, this.loc_2.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_2.getBlockX(), y, this.loc_1.getBlockZ()).identify());
        }
        for (int x = this.loc_1.getBlockX(); x <= this.loc_1.getBlockX() + this.x_distance; ++x) {
            list.add(new dLocation(this.loc_1.getWorld(), x, this.loc_1.getBlockY(), this.loc_1.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), x, this.loc_1.getBlockY(), this.loc_2.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), x, this.loc_2.getBlockY(), this.loc_2.getBlockZ()).identify());
            list.add(new dLocation(this.loc_1.getWorld(), x, this.loc_2.getBlockY(), this.loc_1.getBlockZ()).identify());
        }
        for (int z = this.loc_1.getBlockZ(); z <= this.loc_1.getBlockZ() + this.z_distance; ++z) {
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_1.getBlockX(), this.loc_1.getBlockY(), z).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_2.getBlockX(), this.loc_2.getBlockY(), z).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_1.getBlockX(), this.loc_2.getBlockY(), z).identify());
            list.add(new dLocation(this.loc_1.getWorld(), this.loc_2.getBlockX(), this.loc_1.getBlockY(), z).identify());
        }
        return list;
    }

    public dList getBlocks() {
        dList list = new dList("");
        for (int x = 0; x != this.x_distance + 1; ++x) {
            for (int y = 0; y != this.y_distance + 1; ++y) {
                for (int z = 0; z != this.z_distance + 1; ++z) {
                    dLocation loc = new dLocation(this.loc_1.clone().add((double)x, (double)y, (double)z));
                    if (!this.filter.isEmpty()) {
                        for (dObject material : this.filter) {
                            if (!loc.getBlock().getType().name().equalsIgnoreCase(((dMaterial)material).getMaterial().name())) continue;
                            list.add(loc.identify());
                        }
                        continue;
                    }
                    list.add(loc.identify());
                }
            }
        }
        return list;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="cuboid")
    public String getSaveObject() {
        return this.loc_1.getBlockX() + "," + this.loc_1.getBlockY() + "," + this.loc_1.getBlockZ() + "," + this.loc_1.getWorld().getName() + "|" + this.loc_2.getBlockX() + "," + this.loc_2.getBlockY() + "," + this.loc_2.getBlockZ() + "," + this.loc_2.getWorld().getName();
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dCuboid setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.isUnique() ? "<G>" + this.prefix + "='<A>" + NotableManager.getSavedId(this) + "(<Y>" + this.identify() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        return "cu@" + this.loc_1.getBlockX() + "," + this.loc_1.getBlockY() + "," + this.loc_1.getBlockZ() + "," + this.loc_1.getWorld().getName() + "|" + this.loc_2.getBlockX() + "," + this.loc_2.getBlockY() + "," + this.loc_2.getBlockZ() + "," + this.loc_2.getWorld().getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("get_blocks")) {
            return new dList(this.getBlocks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_outline")) {
            return new dList(this.getOutline()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("filter")) {
            return new dList(this.filter).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within")) {
            dLocation loc = dLocation.valueOf(attribute.getContext(1));
            return new Element(this.isInsideCuboid(loc)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("min")) {
            return this.loc_1.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max")) {
            return this.loc_2.getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }
}

