/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemScriptHelper
implements Listener {
    public static Map<String, ItemScriptContainer> item_scripts = new ConcurrentHashMap<String, ItemScriptContainer>(8, 0.9f, 1);

    public ItemScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, Object> context) {
        String determination = "none";
        for (ItemScriptContainer script : item_scripts.values()) {
            if (script == null) continue;
            for (String eventName : eventNames) {
                List<ScriptEntry> entries;
                if (!script.contains("EVENTS.ON " + eventName.toUpperCase()) || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
                dB.report("Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                dB.echoDebug(dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
                if (context != null) {
                    for (Map.Entry<String, Object> entry : context.entrySet()) {
                        ScriptBuilder.addObjectToEntries(entries, entry.getKey(), entry.getValue());
                    }
                }
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                InstantQueue.getQueue(null).addEntries(entries).start();
                if (!DetermineCommand.hasOutcome(id)) continue;
                determination = DetermineCommand.getOutcome(id);
            }
        }
        return determination;
    }

    public static boolean isItemScript(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        if (!item.getItemMeta().hasLore()) {
            return false;
        }
        for (String line : item.getItemMeta().getLore()) {
            if (!ChatColor.stripColor((String)line).substring(0, 3).equalsIgnoreCase("id:") || !dScript.matches(ChatColor.stripColor((String)line).substring(3))) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void boundPrepareItem(PrepareItemCraftEvent event) {
        ArrayList<ItemStack> clonedMatrix = new ArrayList<ItemStack>(Arrays.asList(event.getInventory().getMatrix()));
        block0: for (int i = 0; i < clonedMatrix.size(); ++i) {
            ItemStack stack = (ItemStack)clonedMatrix.get(i);
            if (stack == null || !stack.hasItemMeta() || !stack.getItemMeta().hasLore()) continue;
            for (String line : stack.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)line).substring(0, 3).equalsIgnoreCase("id:") || !dScript.matches(ChatColor.stripColor((String)line).substring(3)) || !dScript.valueOf((String)ChatColor.stripColor((String)line).substring((int)3)).getContainer().getAsContainerType(ItemScriptContainer.class).bound) continue;
                clonedMatrix.remove(stack);
                event.getView().getPlayer().getInventory().addItem(new ItemStack[]{stack});
                continue block0;
            }
        }
        event.getInventory().setMatrix(clonedMatrix.toArray(new ItemStack[clonedMatrix.size()]));
    }

    @EventHandler
    public void boundDropItem(PlayerDropItemEvent event) {
        if (!event.getItemDrop().getItemStack().hasItemMeta()) {
            return;
        }
        if (!event.getItemDrop().getItemStack().getItemMeta().hasLore()) {
            return;
        }
        for (String line : event.getItemDrop().getItemStack().getItemMeta().getLore()) {
            if (!ChatColor.stripColor((String)line).substring(0, 3).equalsIgnoreCase("id:") || !dScript.matches(ChatColor.stripColor((String)line).substring(3)) || !dScript.valueOf((String)ChatColor.stripColor((String)line).substring((int)3)).getContainer().getAsContainerType(ItemScriptContainer.class).bound) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void craftItem(CraftItemEvent event) {
        if (ItemScriptHelper.isItemScript(event.getRecipe().getResult())) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            String determination = ItemScriptHelper.doEvents(Arrays.asList("craft"), null, (Player)event.getWhoClicked(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void dropItem(PlayerDropItemEvent event) {
        if (ItemScriptHelper.isItemScript(event.getItemDrop().getItemStack())) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("location", new dLocation(event.getItemDrop().getLocation()));
            String determination = ItemScriptHelper.doEvents(Arrays.asList("drop"), null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        }
    }
}

