/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.UUID;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.BracedCommand;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ForEachCommand
extends BracedCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (scriptEntry.hasObject("list") || !arg.matchesArgumentType(dList.class)) continue;
            scriptEntry.addObject("list", arg.asType(dList.class));
        }
        if (!scriptEntry.hasObject("list")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LIST");
        }
        scriptEntry.addObject("entries", this.getBracedCommands(scriptEntry, 1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dList list = (dList)scriptEntry.getObject("list");
        ArrayList entries = (ArrayList)scriptEntry.getObject("entries");
        dB.report(this.getName(), list.debug());
        String queueId = UUID.randomUUID().toString();
        for (String value : list) {
            if (scriptEntry.getResidingQueue().getWasCleared()) {
                return;
            }
            ArrayList<ScriptEntry> newEntries = new ArrayList<ScriptEntry>();
            for (ScriptEntry entr : entries) {
                try {
                    ScriptEntry toadd = entr.clone();
                    toadd.getObjects().clear();
                    newEntries.add(toadd);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            InstantQueue queue = new InstantQueue(queueId);
            queue.addDefinition("parent_queue", scriptEntry.getResidingQueue().id);
            scriptEntry.getResidingQueue().addDefinition("value", value);
            queue.addDefinition("value", value);
            queue.addEntries(newEntries);
            queue.start();
        }
    }
}

