/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.npc.EngageCommand;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.tags.core.NPCTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.util.Anchor;
import net.minecraft.server.v1_6_R2.EntityLiving;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPC
implements dObject {
    private int npcid = -1;
    private final Location locationCache = new Location(null, 0.0, 0.0, 0.0);
    private String prefix = "npc";

    public static dNPC mirrorCitizensNPC(NPC npc) {
        if (dNPCRegistry.denizenNPCs.containsKey(npc.getId())) {
            return dNPCRegistry.denizenNPCs.get(npc.getId());
        }
        return new dNPC(npc);
    }

    @ObjectFetcher(value="n")
    public static dNPC valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (aH.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            if (dNPCRegistry.denizenNPCs.containsKey(aH.getIntegerFrom(string))) {
                return dNPCRegistry.denizenNPCs.get(aH.getIntegerFrom(string));
            }
            NPC npc = CitizensAPI.getNPCRegistry().getById(aH.getIntegerFrom(string));
            if (npc != null) {
                return new dNPC(npc);
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return new dNPC(test);
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (aH.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            NPC npc = CitizensAPI.getNPCRegistry().getById(aH.getIntegerFrom(string));
            if (npc != null) {
                return true;
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getCitizen() != null;
    }

    public dNPC(NPC citizensNPC) {
        if (citizensNPC != null) {
            this.npcid = citizensNPC.getId();
        }
        if (this.npcid >= 0 && !dNPCRegistry.denizenNPCs.containsKey(this.npcid)) {
            dNPCRegistry.denizenNPCs.put(this.npcid, this);
        }
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizen() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (npc == null) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch a NPC. Has this NPC been removed?");
        }
        return npc;
    }

    public LivingEntity getEntity() {
        try {
            return this.getCitizen().getBukkitEntity();
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch a NPC entity. Has this NPC been removed?");
            return null;
        }
    }

    public dEntity getDenizenEntity() {
        try {
            return new dEntity((Entity)this.getCitizen().getBukkitEntity());
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered a NPE while trying to fetch a NPC entity. Has this NPC been removed?");
            return null;
        }
    }

    public EntityType getEntityType() {
        return this.getCitizen().getBukkitEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.getCitizen().getId();
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(dPlayer player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(dPlayer player, Class<? extends AbstractTrigger> triggerType) {
        boolean db = dB.debugMode;
        dB.debugMode = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        dB.debugMode = db;
        return script;
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    public dLocation getLocation() {
        if (this.isSpawned()) {
            return new dLocation(this.getCitizen().getBukkitEntity().getLocation(this.locationCache));
        }
        return null;
    }

    public dLocation getEyeLocation() {
        if (this.isSpawned()) {
            return new dLocation(this.getCitizen().getBukkitEntity().getEyeLocation());
        }
        return null;
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.getCitizen().getName() + "/" + this.getCitizen().getId();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        return this.getCitizen().isSpawned();
    }

    public boolean isVulnerable() {
        return true;
    }

    public String getOwner() {
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
    }

    public AssignmentTrait getAssignmentTrait() {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            this.getCitizen().addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class);
    }

    public NicknameTrait getNicknameTrait() {
        if (!this.getCitizen().hasTrait(NicknameTrait.class)) {
            this.getCitizen().addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)this.getCitizen().getTrait(NicknameTrait.class);
    }

    public HealthTrait getHealthTrait() {
        if (!this.getCitizen().hasTrait(HealthTrait.class)) {
            this.getCitizen().addTrait(HealthTrait.class);
        }
        return (HealthTrait)this.getCitizen().getTrait(HealthTrait.class);
    }

    public TriggerTrait getTriggerTrait() {
        if (!this.getCitizen().hasTrait(TriggerTrait.class)) {
            this.getCitizen().addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)this.getCitizen().getTrait(TriggerTrait.class);
    }

    public void action(String actionName, dPlayer player, Map<String, dObject> context) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            DenizenAPI.getCurrentInstance().getNPCRegistry().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment(), context);
        }
    }

    public void action(String actionName, dPlayer player) {
        this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        return "n@" + this.npcid;
    }

    @Override
    public dNPC setPrefix(String prefix) {
        return this;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        Class trait;
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("name.nickname")) {
            return new Element(this.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)this.getCitizen().getTrait(NicknameTrait.class)).getNickname() : this.getName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(ChatColor.stripColor((String)this.getName())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_traits")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Trait trait2 : this.getCitizen().getTraits()) {
                list.add(trait2.getName());
            }
            return new dList((List<String>)list).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_trait") && attribute.hasContext(1) && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getContext(1))) != null) {
            return new Element(this.getCitizen().hasTrait(trait)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor.list") || attribute.startsWith("anchors.list")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Anchor anchor : ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors()) {
                list.add(anchor.getName());
            }
            return new dList((List<String>)list).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("has_anchors")) {
            return new Element(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors().size() > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor") && attribute.hasContext(1) && ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)) != null) {
            return new dLocation(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)).getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return "null";
            }
            String flag_name = attribute.getContext(1);
            attribute.fulfill(1);
            if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.npcHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("size") && !FlagManager.npcHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(1));
            }
            if (FlagManager.npcHasFlag(this, flag_name)) {
                return new dList(DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.getId(), flag_name)).getAttribute(attribute);
            }
            return "null";
        }
        if (attribute.startsWith("id")) {
            return new Element(this.getId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            return new Element(this.getOwner()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return new dInventory(this.getEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_spawned")) {
            return new Element(this.isSpawned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.previous_location")) {
            return NPCTags.previousLocations.containsKey(this.getId()) ? NPCTags.previousLocations.get(this.getId()).getAttribute(attribute.fulfill(2)) : "null";
        }
        if (attribute.startsWith("script")) {
            NPC citizen = this.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()) {
                return "null";
            }
            return new Element(((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).getAssignment().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("navigator.is_navigating")) {
            return new Element(this.getNavigator().isNavigating()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed")) {
            return new Element(Float.valueOf(this.getNavigator().getLocalParameters().speed())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.range")) {
            return new Element(Float.valueOf(this.getNavigator().getLocalParameters().range())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.attack_strategy")) {
            return new Element(this.getNavigator().getLocalParameters().attackStrategy().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed_modifier")) {
            return new Element(Float.valueOf(this.getNavigator().getLocalParameters().speedModifier())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.base_speed")) {
            return new Element(Float.valueOf(this.getNavigator().getLocalParameters().baseSpeed())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.avoid_water")) {
            return new Element(this.getNavigator().getLocalParameters().avoidWater()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_location")) {
            return this.getNavigator().getTargetAsLocation() != null ? new dLocation(this.getNavigator().getTargetAsLocation()).getAttribute(attribute.fulfill(2)) : "null";
        }
        if (attribute.startsWith("navigator.is_fighting")) {
            return new Element(this.getNavigator().getEntityTarget().isAggressive()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_type")) {
            return new Element(this.getNavigator().getTargetType().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_entity")) {
            return this.getNavigator().getEntityTarget().getTarget() != null ? new dEntity((Entity)this.getNavigator().getEntityTarget().getTarget()).getAttribute(attribute.fulfill(2)) : "null";
        }
        return this.getEntity() != null ? new dEntity((Entity)this.getEntity()).getAttribute(attribute) : new Element(this.identify()).getAttribute(attribute);
    }
}

