/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import java.util.HashSet;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import org.bukkit.entity.Player;

public class MidiCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("listeners") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("listeners", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("tempo") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("tempo", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file")) {
                String path = this.denizen.getDataFolder() + File.separator + "midi" + File.separator + arg.getValue();
                if (!path.endsWith(".mid")) {
                    path = path + ".mid";
                }
                scriptEntry.addObject("file", new Element(path));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("file")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "FILE");
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("listeners")) {
            scriptEntry.addObject("listeners", new dList(scriptEntry.getPlayer().identify()));
        }
        if (!scriptEntry.hasObject("tempo")) {
            scriptEntry.addObject("tempo", new Element(1));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        File file;
        try {
            file = new File(scriptEntry.getElement("file").asString());
        }
        catch (Exception ex) {
            dB.echoError("Invalid file " + scriptEntry.getElement("file").asString());
            return;
        }
        if (!file.exists()) {
            dB.echoError("Invalid file " + scriptEntry.getElement("file").asString());
            return;
        }
        dList listeners = (dList)scriptEntry.getObject("listeners");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        float tempo = (float)scriptEntry.getElement("tempo").asDouble();
        dB.report(this.getName(), aH.debugObj("file", file.getPath()) + (listeners != null ? listeners.debug() : "") + (location != null ? location.debug() : "") + aH.debugObj("Tempo", Float.valueOf(tempo)));
        if (location != null) {
            MidiUtil.playMidiQuietly(file, tempo, location);
        } else {
            HashSet<Player> listenerSet = new HashSet<Player>();
            for (String player : listeners.toArray()) {
                listenerSet.add(dPlayer.valueOf(player).getPlayerEntity());
            }
            MidiUtil.playMidiQuietly(file, tempo, listenerSet);
        }
    }
}

