/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PushCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin, o, source, shooter, s")) {
                if (arg.matchesArgumentType(dEntity.class)) {
                    scriptEntry.addObject("originEntity", arg.asType(dEntity.class));
                    continue;
                }
                if (arg.matchesArgumentType(dLocation.class)) {
                    scriptEntry.addObject("originLocation", arg.asType(dLocation.class));
                    continue;
                }
                dB.echoError("Ignoring unrecognized argument: " + arg.raw_value);
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("destination, d")) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("speed, s")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            dB.echoError("Ignoring unrecognized argument: " + arg.raw_value);
        }
        if (!scriptEntry.hasObject("originLocation")) {
            scriptEntry.defaultObject("originEntity", scriptEntry.hasNPC() ? scriptEntry.getNPC().getDenizenEntity() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("speed", new Element(1.5));
        scriptEntry.defaultObject("duration", new Duration(20));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "entities");
        }
        if (!scriptEntry.hasObject("originEntity") && !scriptEntry.hasObject("originLocation")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "origin");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation destination;
        LivingEntity shooter;
        dEntity originEntity = (dEntity)scriptEntry.getObject("originEntity");
        dLocation originLocation = scriptEntry.hasObject("originLocation") ? (dLocation)scriptEntry.getObject("originLocation") : new dLocation(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0));
        LivingEntity livingEntity = shooter = originEntity != null && originEntity.isLivingEntity() ? originEntity.getLivingEntity() : null;
        dLocation dLocation2 = scriptEntry.hasObject("destination") ? (dLocation)scriptEntry.getObject("destination") : (destination = shooter != null ? new dLocation(shooter.getEyeLocation().add(shooter.getEyeLocation().getDirection().multiply(30))) : null);
        if (destination == null) {
            dB.report(this.getName(), "No destination specified!");
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        final dScript script = (dScript)scriptEntry.getObject("script");
        final double speed = scriptEntry.getElement("speed").asDouble();
        final int maxTicks = ((Duration)scriptEntry.getObject("duration")).getTicksAsInt() / 2;
        dB.report(this.getName(), aH.debugObj("origin", shooter) + aH.debugObj("entities", entities.toString()) + aH.debugObj("destination", destination) + aH.debugObj("speed", speed) + aH.debugObj("max ticks", maxTicks) + (script != null ? aH.debugObj("script", script) : ""));
        if (shooter != null && (originEntity.isNPC() || !Rotation.isFacingLocation((Entity)shooter, (Location)destination, 45.0f))) {
            Rotation.faceLocation((Entity)shooter, destination);
        }
        final dList entityList = new dList();
        for (dEntity entity : entities) {
            entity.spawnAt(originLocation);
            entityList.add(entity.toString());
            Rotation.faceLocation(entity.getBukkitEntity(), destination);
            if (!(entity.getBukkitEntity() instanceof Projectile) || shooter == null) continue;
            ((Projectile)entity.getBukkitEntity()).setShooter(shooter);
        }
        scriptEntry.addObject("pushed_entities", entityList);
        Position.mount(Conversion.convert(entities));
        final dEntity lastEntity = (dEntity)entities.get(entities.size() - 1);
        final Vector v2 = destination.toVector();
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (this.runs < maxTicks && lastEntity.isValid()) {
                    Vector v1 = lastEntity.getLocation().toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(speed);
                    lastEntity.setVelocity(v3);
                    ++this.runs;
                    if (Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        this.runs = maxTicks;
                    }
                    if (lastEntity.getLocation().add(v3).getBlock().getType() != Material.AIR) {
                        this.runs = maxTicks;
                    }
                } else {
                    this.cancel();
                    if (script != null) {
                        List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.getPlayer(), scriptEntry.getNPC());
                        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue._getNextId()).addEntries(entries);
                        queue.addDefinition("location", lastEntity.getLocation().identify());
                        queue.addDefinition("pushed_entities", entityList.toString());
                        queue.addDefinition("last_entity", lastEntity.identify());
                        queue.start();
                    }
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
    }
}

