/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.blocks.FakeBlock;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ShowFakeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dList locations = new dList();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dLocation.class)) {
                locations.add(arg.getValue());
                continue;
            }
            if (arg.matchesArgumentType(dList.class)) {
                for (String item : dList.valueOf(arg.getValue())) {
                    if (!dLocation.matches(item)) continue;
                    locations.add(item);
                }
                continue;
            }
            if (arg.matchesPrefix("d, duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!arg.matchesArgumentType(dMaterial.class)) continue;
            scriptEntry.addObject("material", arg.asType(dMaterial.class));
        }
        if (locations.isEmpty()) {
            throw new InvalidArgumentsException("Must specify at least one valid location!");
        }
        if (scriptEntry.getPlayer() == null || !scriptEntry.getPlayer().isOnline()) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        scriptEntry.addObject("locations", locations);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Duration duration = !scriptEntry.hasObject("duration") ? new Duration(10) : (Duration)scriptEntry.getObject("duration");
        dMaterial material = (dMaterial)scriptEntry.getObject("material");
        dList list = (dList)scriptEntry.getObject("locations");
        dB.report(this.getName(), material.debug() + list.debug() + scriptEntry.getPlayer().debug() + duration.debug());
        for (dObject obj : list.filter(dLocation.class)) {
            new FakeBlock(scriptEntry.getPlayer(), (dLocation)obj, material, duration);
        }
    }
}

