/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockListenerInstance
extends AbstractListener
implements Listener {
    BlockType type = null;
    dList blocks;
    Integer required = 1;
    Integer blocks_so_far = 0;
    String region = null;
    dCuboid cuboid = null;
    List<Integer> itemsCollected = new ArrayList<Integer>();
    List<Location> blocksPlaced = new ArrayList<Location>();

    @Override
    public void onBuild(List<aH.Argument> args) {
        for (aH.Argument arg : args) {
            if (arg.matchesEnum(BlockType.values()) && this.type == null) {
                this.type = BlockType.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (arg.matchesPrefix("qty, q") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                this.required = aH.getIntegerFrom(arg.getValue());
                continue;
            }
            if (arg.matchesPrefix("region, r")) {
                this.region = arg.getValue();
                continue;
            }
            if (arg.matchesPrefix("cuboid, c") && arg.matchesArgumentType(dCuboid.class)) {
                this.cuboid = (dCuboid)arg.asType(dCuboid.class);
                continue;
            }
            if (!arg.matchesPrefix("blocks, block, b, name, names")) continue;
            this.blocks = (dList)arg.asType(dList.class);
        }
        if (this.blocks == null) {
            this.blocks = new dList("*");
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: BUILD, COLLECT, BREAK");
            this.cancel();
        }
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Blocks", this.blocks);
        this.store("Quantity", this.required);
        this.store("Current Blocks", this.blocks_so_far);
        this.store("Region", this.region);
        if (this.cuboid != null) {
            this.store("Cuboid", this.cuboid.identify());
        }
    }

    @Override
    public void onLoad() {
        this.type = BlockType.valueOf((String)this.get("Type"));
        this.blocks = new dList((List)this.get("Blocks"));
        this.required = (Integer)this.get("Quantity");
        this.blocks_so_far = (Integer)this.get("Current Blocks");
        this.region = (String)this.get("Region");
        this.cuboid = dCuboid.valueOf((String)this.get("Cuboid"));
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String report() {
        return this.player.getName() + " currently has quest listener '" + this.id + "' active and must " + this.type.name() + " " + Arrays.toString(this.blocks.toArray()) + "'(s). Current progress '" + this.blocks_so_far + "/" + this.required + "'.";
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        BlockBreakEvent.getHandlerList().unregister((Listener)this);
        PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
        BlockPlaceEvent.getHandlerList().unregister((Listener)this);
    }

    public void check() {
        if (this.blocks_so_far >= this.required) {
            this.finish();
        }
    }

    @EventHandler
    public void listenBreak(BlockBreakEvent event) {
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
            return;
        }
        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
            return;
        }
        if (this.type == BlockType.BREAK && (this.blocks.contains(event.getBlock().getType().name().toLowerCase()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId())) || this.blocks.contains("*"))) {
            Integer n = this.blocks_so_far;
            Integer n2 = this.blocks_so_far = Integer.valueOf(this.blocks_so_far + 1);
            dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " broke a " + event.getBlock().getType().toString() + ".");
            this.check();
        }
    }

    @EventHandler
    public void listenCollect(PlayerPickupItemEvent event) {
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
            return;
        }
        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
            return;
        }
        if (this.type == BlockType.COLLECT && (this.blocks.contains(event.getItem().getItemStack().getType().name().toLowerCase()) || this.blocks.contains(String.valueOf(event.getItem().getItemStack().getTypeId())) || this.blocks.contains("*"))) {
            if (this.itemsCollected.contains(event.getItem().getEntityId())) {
                return;
            }
            this.itemsCollected.add(event.getItem().getEntityId());
            this.blocks_so_far = this.blocks_so_far + event.getItem().getItemStack().getAmount();
            dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " collected a " + event.getItem().getItemStack().getType().toString() + ".");
            this.check();
        }
    }

    @EventHandler
    public void listenBucket(PlayerBucketFillEvent event) {
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
            return;
        }
        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
            return;
        }
        if (this.type == BlockType.COLLECT && (this.blocks.contains(event.getBucket().name().toLowerCase()) || this.blocks.contains(String.valueOf(event.getBucket().name().toUpperCase())) || this.blocks.contains("*"))) {
            Integer n = this.blocks_so_far;
            Integer n2 = this.blocks_so_far = Integer.valueOf(this.blocks_so_far + 1);
            dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " collected a " + event.getBucket().name() + ".");
            this.check();
        }
    }

    @EventHandler
    public void listenPlace(BlockPlaceEvent event) {
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
            return;
        }
        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
            return;
        }
        if (this.type == BlockType.BUILD && (this.blocks.contains(event.getBlock().getType().name().toLowerCase()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId())) || this.blocks.contains("*"))) {
            if (this.blocksPlaced.contains(event.getBlock().getLocation())) {
                return;
            }
            this.blocksPlaced.add(event.getBlock().getLocation());
            Integer n = this.blocks_so_far;
            Integer n2 = this.blocks_so_far = Integer.valueOf(this.blocks_so_far + 1);
            dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " placed a " + event.getBlock().getType().toString() + ".");
            this.check();
        }
    }

    @EventHandler
    public void listenTag(ReplaceableTagEvent event) {
        if (!event.matches("LISTENER")) {
            return;
        }
        if (!event.getType().equalsIgnoreCase(this.id)) {
            return;
        }
        if (event.getValue().equalsIgnoreCase("region")) {
            event.setReplaced(this.region);
        } else if (event.getValue().equalsIgnoreCase("required")) {
            event.setReplaced(this.required.toString());
        } else if (event.getValue().equalsIgnoreCase("blocks_so_far")) {
            event.setReplaced(this.blocks_so_far.toString());
        } else if (event.getValue().equalsIgnoreCase("blocks")) {
            String blockList = "";
            for (String curTar : this.blocks) {
                blockList = blockList + curTar + ", ";
                blockList = blockList.substring(0, blockList.length() - 1);
            }
            event.setReplaced(blockList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockType {
        BUILD,
        COLLECT,
        BREAK;

    }
}

