/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class dLocation
extends Location
implements dObject {
    static final Pattern notablePattern = Pattern.compile("(\\w+)[;,]((-?\\d+\\.?\\d*,){3,5}\\w+)", 2);
    public static Map<String, dLocation> uniqueObjects = new HashMap<String, dLocation>();
    String prefix = "Location";

    public static boolean isSaved(String id) {
        return uniqueObjects.containsKey(id.toUpperCase());
    }

    public static boolean isSaved(dLocation location) {
        return uniqueObjects.containsValue(location);
    }

    public static boolean isSaved(Location location) {
        for (Map.Entry<String, dLocation> i : uniqueObjects.entrySet()) {
            if (i.getValue() != location) continue;
            return true;
        }
        return uniqueObjects.containsValue(location);
    }

    public static dLocation getSaved(String id) {
        if (uniqueObjects.containsKey(id.toUpperCase())) {
            return uniqueObjects.get(id.toUpperCase());
        }
        return null;
    }

    public static String getSaved(dLocation location) {
        for (Map.Entry<String, dLocation> i : uniqueObjects.entrySet()) {
            if (i.getValue().getBlockX() != location.getBlockX() || i.getValue().getBlockY() != location.getBlockY() || i.getValue().getBlockZ() != location.getBlockZ() || !i.getValue().getWorld().getName().equals(location.getWorld().getName())) continue;
            return i.getKey();
        }
        return null;
    }

    public static String getSaved(Location location) {
        dLocation dLoc = new dLocation(location);
        return dLocation.getSaved(dLoc);
    }

    public static void saveAs(dLocation location, String id) {
        if (location == null) {
            return;
        }
        uniqueObjects.put(id.toUpperCase(), location);
    }

    public static void remove(String id) {
        uniqueObjects.remove(id.toUpperCase());
    }

    public static void _recallLocations() {
        List loclist = DenizenAPI.getCurrentInstance().getSaves().getStringList("dScript.Locations");
        uniqueObjects.clear();
        for (String location : loclist) {
            Matcher m = notablePattern.matcher(location);
            if (!m.matches()) continue;
            String id = m.group(1);
            dLocation loc = dLocation.valueOf(m.group(2));
            uniqueObjects.put(id, loc);
        }
    }

    public static void _saveLocations() {
        ArrayList<String> loclist = new ArrayList<String>();
        for (Map.Entry<String, dLocation> entry : uniqueObjects.entrySet()) {
            loclist.add(entry.getKey() + ";" + entry.getValue().getBlockX() + "," + entry.getValue().getBlockY() + "," + entry.getValue().getBlockZ() + "," + entry.getValue().getYaw() + "," + entry.getValue().getPitch() + "," + entry.getValue().getWorld().getName());
        }
        DenizenAPI.getCurrentInstance().getSaves().set("dScript.Locations", loclist);
    }

    @ObjectFetcher(value="l")
    public static dLocation valueOf(String string) {
        if (string == null) {
            return null;
        }
        Pattern item_by_saved = Pattern.compile("(l@)(.+)");
        Matcher m = item_by_saved.matcher(string);
        if (m.matches() && dLocation.isSaved(m.group(2))) {
            return dLocation.getSaved(m.group(2));
        }
        String[] split = string.replace("l@", "").split(",");
        if (split.length == 4) {
            try {
                return new dLocation(Bukkit.getWorld((String)split[3]), Double.valueOf(split[0]), Double.valueOf(split[1]), Double.valueOf(split[2]));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (split.length == 6) {
            try {
                return new dLocation(Bukkit.getWorld((String)split[5]), Double.valueOf(split[0]), Double.valueOf(split[1]), Double.valueOf(split[2]), Float.valueOf(split[3]).floatValue(), Float.valueOf(split[4]).floatValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        dB.log("valueOf dLocation returning null: " + string);
        return null;
    }

    public static boolean matches(String string) {
        Pattern location_by_saved = Pattern.compile("(l@)(.+)");
        Matcher m = location_by_saved.matcher(string);
        if (m.matches()) {
            return true;
        }
        Pattern location = Pattern.compile("(-?\\d+\\.?\\d*,){3,5}\\w+", 2);
        m = location.matcher(string);
        return m.matches();
    }

    public dLocation(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public dLocation(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public dLocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, pitch, yaw);
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public dLocation rememberAs(String id) {
        dLocation.saveAs(this, id);
        return this;
    }

    public String getObjectType() {
        return "Location";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dLocation setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return dLocation.isSaved(this) ? "<G>" + this.prefix + "='<A>" + dLocation.getSaved(this) + "(<Y>" + this.identify() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return dLocation.isSaved(this);
    }

    public String identify() {
        if (dLocation.isSaved(this)) {
            return "l@" + dLocation.getSaved(this);
        }
        if ((double)this.getYaw() != 0.0 && (double)this.getPitch() != 0.0) {
            return "l@" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorld().getName();
        }
        return "l@" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getWorld().getName();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        String[] ints;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("biome.formatted")) {
            return new Element(this.getBlock().getBiome().name().toLowerCase().replace('_', ' ')).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome.humidity")) {
            return new Element(this.getBlock().getHumidity()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome.temperature")) {
            return new Element(this.getBlock().getTemperature()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome")) {
            return new Element(this.getBlock().getBiome().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("block.below")) {
            return new dLocation(this.add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("block.above")) {
            return new dLocation(this.add(0.0, 1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1) && attribute.getContext(1).split(",").length == 3 && (aH.matchesDouble((ints = attribute.getContext(1).split(",", 3))[0]) || aH.matchesInteger(ints[0])) && (aH.matchesDouble(ints[1]) || aH.matchesInteger(ints[1])) && (aH.matchesDouble(ints[2]) || aH.matchesInteger(ints[2]))) {
            return new dLocation(this.clone().add(Double.valueOf(ints[0]).doubleValue(), Double.valueOf(ints[1]).doubleValue(), Double.valueOf(ints[2]).doubleValue())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("with_pose")) {
            String context = attribute.getContext(1);
            Float pitch = Float.valueOf(0.0f);
            Float yaw = Float.valueOf(0.0f);
            if (dEntity.matches(context)) {
                dEntity ent = dEntity.valueOf(context);
                if (ent.isSpawned()) {
                    pitch = Float.valueOf(ent.getBukkitEntity().getLocation().getPitch());
                    yaw = Float.valueOf(ent.getBukkitEntity().getLocation().getYaw());
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.valueOf(split[0]);
                yaw = Float.valueOf(split[1]);
            }
            dLocation loc = dLocation.valueOf(this.identify());
            loc.setPitch(pitch.floatValue());
            loc.setYaw(yaw.floatValue());
            return loc.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("find") || attribute.startsWith("nearest")) {
            ArrayList<dObject> found;
            attribute.fulfill(1);
            if (attribute.startsWith("blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList<dObject>();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                attribute.fulfill(2);
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (!materials.isEmpty()) {
                                for (dObject dObject2 : materials) {
                                    if (!((dMaterial)dObject2).matchesMaterialData(this.getBlock().getRelative(x, y, z).getType().getNewData(this.getBlock().getRelative(x, y, z).getData()))) continue;
                                    found.add(new dLocation(this.getBlock().getRelative(x, y, z).getLocation()));
                                }
                                continue;
                            }
                            found.add(new dLocation(this.getBlock().getRelative(x, y, z).getLocation()));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return (int)(dLocation.this.distanceSquared(loc1) - dLocation.this.distanceSquared(loc2));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("surface_blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                attribute.fulfill(2);
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (!materials.isEmpty()) {
                                for (dObject dObject3 : materials) {
                                    Location l;
                                    if (!((dMaterial)dObject3).matchesMaterialData(this.getBlock().getRelative(x, y, z).getType().getNewData(this.getBlock().getRelative(x, y, z).getData())) || (l = this.getBlock().getRelative(x, y, z).getLocation()).add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) continue;
                                    found.add(new dLocation(this.getBlock().getRelative(x, y, z).getLocation()));
                                }
                                continue;
                            }
                            Location l = this.getBlock().getRelative(x, y, z).getLocation();
                            if (l.add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) continue;
                            found.add(new dLocation(this.getBlock().getRelative(x, y, z).getLocation()));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return (int)(dLocation.this.distanceSquared(loc1) - dLocation.this.distanceSquared(loc2));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("players") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!Utilities.checkLocation(this, player.getLocation(), radius)) continue;
                    found.add(new dPlayer((OfflinePlayer)player));
                }
                Collections.sort(found, new Comparator<dPlayer>(){

                    @Override
                    public int compare(dPlayer pl1, dPlayer pl2) {
                        return (int)(dLocation.this.distanceSquared(pl1.getLocation()) - dLocation.this.distanceSquared(pl2.getLocation()));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("npcs") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                attribute.fulfill(2);
                for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
                    if (!Utilities.checkLocation(this, (Location)npc.getLocation(), radius)) continue;
                    found.add(npc);
                }
                Collections.sort(found, new Comparator<dNPC>(){

                    @Override
                    public int compare(dNPC npc1, dNPC npc2) {
                        return (int)(dLocation.this.distanceSquared(npc1.getLocation()) - dLocation.this.distanceSquared(npc2.getLocation()));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("npcs") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                attribute.fulfill(2);
                for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
                    if (!Utilities.checkLocation(this, (Location)npc.getLocation(), radius)) continue;
                    found.add(npc);
                }
                Collections.sort(found, new Comparator<dNPC>(){

                    @Override
                    public int compare(dNPC npc1, dNPC npc2) {
                        return (int)(dLocation.this.distanceSquared(npc1.getLocation()) - dLocation.this.distanceSquared(npc2.getLocation()));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                attribute.fulfill(2);
                for (Entity entity : this.getWorld().getEntities()) {
                    if (!Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    found.add(new dEntity(entity));
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return (int)(dLocation.this.distanceSquared(ent1.getBukkitEntity().getLocation()) - dLocation.this.distanceSquared(ent2.getBukkitEntity().getLocation()));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            if (attribute.startsWith("living_entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                found = new ArrayList();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                attribute.fulfill(2);
                for (Entity entity : this.getWorld().getEntities()) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    found.add(new dEntity(entity));
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return (int)(dLocation.this.distanceSquared(ent1.getBukkitEntity().getLocation()) - dLocation.this.distanceSquared(ent2.getBukkitEntity().getLocation()));
                    }
                });
                return new dList(found).getAttribute(attribute);
            }
            return new Element("null").getAttribute(attribute);
        }
        if (attribute.startsWith("inventory")) {
            if (this.getBlock().getState() instanceof InventoryHolder) {
                return new dInventory(this.getBlock().getState()).getAttribute(attribute.fulfill(1));
            }
            return new Element("null").getAttribute(attribute);
        }
        if (attribute.startsWith("block.material")) {
            return new dMaterial(this.getBlock().getType()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("direction.vector")) {
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            return new dLocation(this.getWorld(), -nx, -ny, nz).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("direction")) {
            if (attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
                return new Element(Rotation.getCardinal(Rotation.getYaw(dLocation.valueOf(attribute.getContext(1)).toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute.fulfill(1));
            }
            return new Element(Rotation.getCardinal(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation toLocation = dLocation.valueOf(attribute.getContext(1));
            if (attribute.getAttribute(2).startsWith("horizontal")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(toLocation.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(toLocation.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(2));
                }
            } else if (attribute.getAttribute(2).startsWith("vertical")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(2));
                }
            } else {
                return new Element(this.distance(toLocation)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("simple")) {
            return new Element(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + "," + this.getWorld().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("formatted.simple")) {
            return new Element("X '" + this.getBlockX() + "', Y '" + this.getBlockY() + "', Z '" + this.getBlockZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("formatted")) {
            return new Element("X '" + this.getX() + "', Y '" + this.getY() + "', Z '" + this.getZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_liquid")) {
            return new Element(this.getBlock().isLiquid()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("light.from_blocks") || attribute.startsWith("light.blocks")) {
            return new Element(this.getBlock().getLightFromBlocks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light.from_sky") || attribute.startsWith("light.sky")) {
            return new Element(this.getBlock().getLightFromSky()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light")) {
            return new Element(this.getBlock().getLightLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("pitch")) {
            return new Element(Float.valueOf(this.getPitch())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("yaw.raw")) {
            return new Element(Float.valueOf(this.getYaw())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw")) {
            return new Element(Rotation.normalizeYaw(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("facing") && attribute.hasContext(1)) {
            int degrees = 45;
            int attributePos = 1;
            if (attribute.getAttribute(2).startsWith("degrees") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                degrees = attribute.getIntContext(2);
                ++attributePos;
            }
            if (dLocation.matches(attribute.getContext(1))) {
                return new Element(Rotation.isFacingLocation(this, (Location)dLocation.valueOf(attribute.getContext(1)), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
            if (dEntity.matches(attribute.getContext(1))) {
                return new Element(Rotation.isFacingLocation(this, dEntity.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
        }
        if (attribute.startsWith("power")) {
            return new Element(this.getBlock().getBlockPower()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_region")) {
            if (Depends.worldGuard == null) {
                dB.echoError("Cannot check region! WorldGuard is not loaded!");
                return null;
            }
            if (attribute.hasContext(1)) {
                dList region_list = dList.valueOf(attribute.getContext(1));
                for (String region : region_list) {
                    if (!WorldGuardUtilities.inRegion(this, region)) continue;
                    return Element.TRUE.getAttribute(attribute.fulfill(1));
                }
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return new Element(WorldGuardUtilities.inRegion(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("regions")) {
            return new dList(WorldGuardUtilities.getRegions(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return dWorld.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("block.x")) {
            return new Element(this.getBlockX()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("block.y")) {
            return new Element(this.getBlockY()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("block.z")) {
            return new Element(this.getBlockZ()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("x")) {
            return new Element(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("y")) {
            return new Element(this.getY()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new Element(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("block.sign_contents")) {
            if (this.getBlock().getState() instanceof Sign) {
                return new dList(Arrays.asList(((Sign)this.getBlock().getState()).getLines())).getAttribute(attribute.fulfill(2));
            }
            return "null";
        }
        if (attribute.startsWith("highest")) {
            return new dLocation(this.getWorld().getHighestBlockAt((Location)this).getLocation()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

