/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("remove") && arg.matches("remove, cancel")) {
                scriptEntry.addObject("remove", Element.TRUE);
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("amplifier") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("power, p")) {
                scriptEntry.addObject("amplifier", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("effect") && PotionEffectType.getByName((String)arg.asElement().asString()) != null) {
                scriptEntry.addObject("effect", PotionEffectType.getByName((String)arg.asElement().asString()));
                continue;
            }
            if (scriptEntry.hasObject("entities") || !arg.matchesArgumentList(dEntity.class)) continue;
            scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
        }
        scriptEntry.defaultObject("entities", scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null, scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null);
        if (!scriptEntry.hasObject("effect")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "PotionType");
        }
        scriptEntry.defaultObject("duration", new Duration(60));
        scriptEntry.defaultObject("amplifier", new Element(1));
        scriptEntry.defaultObject("remove", Element.FALSE);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        PotionEffectType effect = (PotionEffectType)scriptEntry.getObject("effect");
        int amplifier = scriptEntry.getElement("amplifier").asInt();
        Duration duration = (Duration)scriptEntry.getObject("duration");
        boolean remove = scriptEntry.getElement("remove").asBoolean();
        dB.report(this.getName(), aH.debugObj("Target(s)", entities.toString()) + aH.debugObj("Effect", effect.getName()) + aH.debugObj("Amplifier", amplifier) + duration.debug());
        for (dEntity entity : entities) {
            PotionEffect potion;
            if (entity.getLivingEntity().hasPotionEffect(effect)) {
                entity.getLivingEntity().removePotionEffect(effect);
            }
            if (remove || (potion = new PotionEffect(effect, duration.getTicksAsInt(), amplifier)).apply(entity.getLivingEntity())) continue;
            dB.echoError("Bukkit was unable to apply '" + potion.getType().getName() + "' to '" + entity.toString() + "'.");
        }
    }
}

