/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class NameplateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ChatColor color = null;
        boolean player = false;
        String text = null;
        List<String> args = scriptEntry.getArguments();
        for (String arg : args) {
            if (aH.matchesValueArg("COLOR", arg, aH.ArgumentType.String)) {
                try {
                    color = ChatColor.valueOf((String)aH.getStringFrom(arg).toUpperCase());
                }
                catch (Exception e) {
                    dB.echoDebug("...COLOR could not be set: '%s' is an invalid color!", aH.getStringFrom(arg));
                }
                continue;
            }
            if (aH.matchesValueArg("TARGET", arg, aH.ArgumentType.Word)) {
                player = true;
                scriptEntry.setPlayer(aH.getPlayerFrom(arg));
                continue;
            }
            if (!aH.matchesValueArg("SET", arg, aH.ArgumentType.Custom)) continue;
            text = aH.getStringFrom(arg);
        }
        scriptEntry.addObject("color", color).addObject("player", player).addObject("text", text);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Boolean player = (Boolean)scriptEntry.getObject("player");
        ChatColor color = (ChatColor)scriptEntry.getObject("color");
        String text = (String)scriptEntry.getObject("text");
        if (text != null) {
            if (text.equalsIgnoreCase("none")) {
                scriptEntry.getNPC().getEntity().setCustomNameVisible(false);
                dB.echoDebug("none");
            } else {
                scriptEntry.getNPC().getEntity().setCustomNameVisible(true);
                scriptEntry.getNPC().getEntity().setCustomName(text);
                dB.echoDebug(text);
            }
            if (scriptEntry.getNPC().getEntity() instanceof Player) {
                ((Player)scriptEntry.getNPC().getEntity()).setDisplayName(text);
            }
        }
        if (color != null) {
            if (!scriptEntry.getNPC().getCitizen().hasTrait(NameplateTrait.class)) {
                scriptEntry.getNPC().getCitizen().addTrait(NameplateTrait.class);
            }
            NameplateTrait trait = (NameplateTrait)scriptEntry.getNPC().getCitizen().getTrait(NameplateTrait.class);
            if (player.booleanValue()) {
                trait.setColor(color, scriptEntry.getPlayer().getName());
            } else {
                trait.setColor(color);
            }
        }
    }
}

