/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.SheepDyeWoolEvent;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldScriptHelper
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public WorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, dObject> context) {
        String determination = "none";
        if (dB.showEventsFiring) {
            dB.log("Fired for '" + eventNames.toString() + "'");
        }
        for (WorldScriptContainer script : world_scripts.values()) {
            if (script == null) continue;
            for (String eventName : eventNames) {
                List<ScriptEntry> entries;
                if (!script.contains("EVENTS.ON " + eventName.toUpperCase()) || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
                dB.report("Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                dB.echoDebug(dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                ScriptQueue queue = InstantQueue.getQueue(null).addEntries(entries);
                if (context != null) {
                    for (Map.Entry<String, dObject> entry : context.entrySet()) {
                        queue.addContext(entry.getKey(), entry.getValue());
                    }
                }
                queue.start();
                if (!DetermineCommand.hasOutcome(id)) continue;
                determination = DetermineCommand.getOutcome(id);
            }
        }
        return determination;
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Block block = event.getBlock();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(block.getLocation()));
        context.put("material", material);
        dItem item = new dItem(event.getPlayer().getItemInHand());
        dMaterial itemMaterial = item.getMaterial();
        ArrayList<String> events = new ArrayList<String>();
        events.add("player breaks block");
        events.add("player breaks " + material.identify());
        events.add("player breaks block with " + item.identify());
        events.add("player breaks " + material.identify() + " with " + item.identify());
        events.add("player breaks block with " + itemMaterial.identify());
        events.add("player breaks " + material.identify() + " with " + itemMaterial.identify());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.toUpperCase().startsWith("NOTHING")) {
            event.setCancelled(true);
            block.setType(Material.AIR);
        } else if (aH.Argument.valueOf(determination).matchesArgumentList(dItem.class)) {
            List<dObject> list;
            event.setCancelled(true);
            block.setType(Material.AIR);
            List<dObject> newItems = list = dList.valueOf(determination).filter(dItem.class);
            for (dItem dItem2 : newItems) {
                block.getWorld().dropItemNaturally(block.getLocation(), dItem2.getItemStack());
            }
        }
    }

    @EventHandler
    public void blockBurn(BlockBurnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        dMaterial material = new dMaterial(event.getBlock().getType());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block burns", material.identify() + " burns"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockCanBuild(BlockCanBuildEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial oldMaterial = new dMaterial(event.getBlock().getType());
        dMaterial newMaterial = new dMaterial(event.getMaterial());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("old_material", oldMaterial);
        context.put("new_material", newMaterial);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block being built", "block being built on " + oldMaterial.identify(), newMaterial.identify() + " being built", newMaterial.identify() + " being built on " + oldMaterial.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("BUILDABLE")) {
            event.setBuildable(true);
        }
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setBuildable(false);
        }
    }

    @EventHandler
    public void blockDamage(BlockDamageEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player damages block", "player damages " + material.identify()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("INSTABREAK")) {
            event.setInstaBreak(true);
        }
    }

    @EventHandler
    public void blockDispense(BlockDispenseEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block dispenses item", "block dispenses " + item.identify(), material.identify() + " dispenses item", material.identify() + " dispenses " + item.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setVelocity(event.getVelocity().normalize().multiply(aH.getDoubleFrom(determination)));
        }
    }

    @EventHandler
    public void blockFade(BlockFadeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block fades", material.identify() + " fades"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockForm(BlockFormEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block forms", material.identify() + " forms"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockFromTo(BlockFromToEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("destination", new dLocation(event.getToBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("liquid spreads", material.identify() + " spreads"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockGrow(BlockGrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block grows", material.identify() + " grows"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockIgnite(BlockIgniteEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block ignites", material.identify() + " ignites"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPistonExtend(BlockPistonExtendEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        context.put("length", new Element(event.getLength()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("piston extends", material.identify() + " extends"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPistonRetract(BlockPistonRetractEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("retract_location", new dLocation(event.getRetractLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("piston retracts", material.identify() + " retracts"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPlace(BlockPlaceEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player places block", "player places " + material.identify()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockRedstone(BlockRedstoneEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        ArrayList<String> events = new ArrayList<String>();
        if (event.getNewCurrent() > 0) {
            events.add("block powers");
            events.add(material.identify() + " powers");
            events.add("block powered");
            events.add(material.identify() + " powered");
        } else {
            events.add("block unpowers");
            events.add(material.identify() + " unpowers");
            events.add("block unpowered");
            events.add(material.identify() + " unpowered");
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler
    public void blockSpread(BlockSpreadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block spreads", material.identify() + " spreads"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void brew(BrewEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("inventory", new dInventory((Inventory)event.getContents()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("brewing stand brews"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityBlockForm(EntityBlockFormEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        context.put("entity", entity.getDenizenObject());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity forms block", "entity forms " + material.identify(), entityType + " forms block", entityType + " forms " + material.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void furnaceBurn(FurnaceBurnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getFuel());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("furnace burns item", "furnace burns " + item.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setBurnTime(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void furnaceExtract(FurnaceExtractEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial itemMaterial = new dMaterial(event.getItemType());
        dItem item = new dItem(itemMaterial, event.getItemAmount());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player takes item from furnace", "player takes " + item.identify() + " from furnace", "player takes " + itemMaterial.identify() + " from furnace"), null, event.getPlayer(), context);
        if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setExpToDrop(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void furnaceSmelt(FurnaceSmeltEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem source = new dItem(event.getSource());
        dItem result = new dItem(event.getResult());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("source_item", source);
        context.put("result_item", result);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("furnace smelts item", "furnace smelts " + source.identify(), "furnace smelts item into " + result.identify(), "furnace smelts " + source.identify() + " into " + result.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (dItem.matches(determination)) {
            event.setResult(dItem.valueOf(determination).getItemStack());
        }
    }

    @EventHandler
    public void leavesDecay(LeavesDecayEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = new dMaterial(event.getBlock().getType());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("leaves decay", material.identify() + " decay"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void signChange(SignChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        dMaterial material = new dMaterial(block.getType());
        context.put("old", new dList(Arrays.asList(sign.getLines())));
        context.put("new", new dList(Arrays.asList(event.getLines())));
        context.put("location", new dLocation(block.getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes sign", "player changes " + material.identify()), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    public void serverStartEvent() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                WorldScriptHelper.this.timeEvent();
            }
        }, Settings.WorldScriptTimeEventFrequency().getTicks(), Settings.WorldScriptTimeEventFrequency().getTicks());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            Bukkit.getServer().shutdown();
        }
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            dWorld currentWorld;
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new dWorld(world)).identify()) && this.current_time.get(currentWorld.identify()) == hour) continue;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("time", new Element(hour));
            context.put("world", currentWorld);
            WorldScriptHelper.doEvents(Arrays.asList("time changes in " + currentWorld.identify(), String.valueOf(hour) + ":00 in " + currentWorld.identify(), "time " + String.valueOf(hour) + " in " + currentWorld.identify()), null, null, context);
            this.current_time.put(currentWorld.identify(), hour);
        }
    }

    @EventHandler
    public void hangingBreak(HangingBreakEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity hanging = new dEntity((Entity)event.getEntity());
        String hangingType = hanging.getEntityType().name();
        String cause = event.getCause().name();
        context.put("hanging", hanging);
        context.put("cause", new Element(cause));
        ArrayList<String> events = new ArrayList<String>();
        events.add("hanging breaks");
        events.add("hanging breaks because " + cause);
        events.add(hangingType + " breaks");
        events.add(hangingType + " breaks because " + cause);
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent subEvent = (HangingBreakByEntityEvent)event;
            dEntity entity = new dEntity(subEvent.getRemover());
            String entityType = entity.getEntityType().name();
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
                entityType = "npc";
            } else if (entity.isPlayer()) {
                player = entity.getPlayer();
            }
            events.add("entity breaks hanging");
            events.add("entity breaks hanging because " + cause);
            events.add("entity breaks " + hangingType);
            events.add("entity breaks " + hangingType + " because " + cause);
            events.add(entityType + " breaks hanging");
            events.add(entityType + " breaks hanging because " + cause);
            events.add(entityType + " breaks " + hangingType);
            events.add(entityType + " breaks " + hangingType + " because " + cause);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void hangingPlace(HangingPlaceEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity hanging = new dEntity((Entity)event.getEntity());
        String hangingType = hanging.getEntityType().name();
        context.put("hanging", hanging);
        context.put("location", new dLocation(event.getBlock().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player places hanging", "player places " + hangingType), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String entityType = entity.getEntityType().name();
        String reason = event.getSpawnReason().name();
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity spawns", "entity spawns because " + event.getSpawnReason().name(), entityType + " spawns", entityType + " spawns because " + reason), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void creeperPower(CreeperPowerEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        dEntity lightning = new dEntity((Entity)event.getLightning());
        String cause = event.getCause().name();
        context.put("entity", entity);
        context.put("lightning", lightning);
        context.put("cause", new Element(cause));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("creeper powered", "creeper powered because " + cause), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityChangeBlock(EntityChangeBlockEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        dMaterial oldMaterial = new dMaterial(event.getBlock().getType());
        dMaterial newMaterial = new dMaterial(event.getTo());
        context.put("entity", entity.getDenizenObject());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("old_material", oldMaterial);
        context.put("new_material", newMaterial);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity changes block", "entity changes " + oldMaterial.identify(), "entity changes block into " + newMaterial.identify(), "entity changes " + oldMaterial.identify() + " into " + newMaterial.identify(), entityType + " changes block", entityType + " changes " + oldMaterial.identify(), entityType + " changes block into " + newMaterial.identify(), entityType + " changes " + oldMaterial.identify() + " into " + newMaterial.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityCombust(EntityCombustEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity).getDenizenObject());
        context.put("duration", new Duration((long)event.getDuration()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity combusts", entity.getType().name() + " combusts"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityDamage(EntityDamageEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        String cause = event.getCause().name();
        context.put("entity", entity.getDenizenObject());
        context.put("damage", new Element(event.getDamage()));
        context.put("cause", new Element(event.getCause().name()));
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        boolean isFatal = false;
        if (entity.isValid() && entity.isLivingEntity() && event.getDamage() >= entity.getLivingEntity().getHealth()) {
            isFatal = true;
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity damaged");
        events.add("entity damaged by " + cause);
        events.add(entityType + " damaged");
        events.add(entityType + " damaged by " + cause);
        if (isFatal) {
            events.add("entity killed");
            events.add("entity killed by " + cause);
            events.add(entityType + " killed");
            events.add(entityType + " killed by " + cause);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
            Player subPlayer = null;
            dNPC subNPC = null;
            dEntity damager = new dEntity(subEvent.getDamager());
            String damagerType = damager.getEntityType().name();
            context.put("damager", damager.getDenizenObject());
            if (damager.isNPC()) {
                subNPC = damager.getDenizenNPC();
                damagerType = "npc";
                if (npc == null) {
                    npc = subNPC;
                }
            } else if (damager.isPlayer()) {
                subPlayer = damager.getPlayer();
                if (player == null) {
                    player = subPlayer;
                }
            } else if (damager.hasShooter()) {
                dEntity shooter = damager.getShooter();
                context.put("shooter", shooter.getDenizenObject());
            }
            events.add("entity damaged by entity");
            events.add("entity damaged by " + damagerType);
            events.add(entityType + " damaged by entity");
            events.add(entityType + " damaged by " + damagerType);
            ArrayList<String> subEvents = new ArrayList<String>();
            subEvents.add("entity damages entity");
            subEvents.add("entity damages " + entityType);
            subEvents.add(damagerType + " damages entity");
            subEvents.add(damagerType + " damages " + entityType);
            if (isFatal) {
                events.add("entity killed by entity");
                events.add("entity killed by " + damagerType);
                events.add(entityType + " killed by entity");
                events.add(entityType + " killed by " + damagerType);
                subEvents.add("entity kills entity");
                subEvents.add("entity kills " + entityType);
                subEvents.add(damagerType + " kills entity");
                subEvents.add(damagerType + " kills " + entityType);
            }
            if ((determination = WorldScriptHelper.doEvents(subEvents, subNPC, subPlayer, context)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
                event.setDamage(aH.getDoubleFrom(determination));
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityExplode(EntityExplodeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        if (event.getEntity() == null) {
            return;
        }
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("entity", entity.getDenizenObject());
        context.put("location", new dLocation(event.getLocation()));
        String blocks = "";
        for (Block block : event.blockList()) {
            blocks = blocks + new dLocation(block.getLocation()) + "|";
        }
        context.put("blocks", blocks.length() > 0 ? new dList(blocks) : null);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explodes", entityType + " explodes"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityRegainHealth(EntityRegainHealthEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        String reason = event.getRegainReason().name();
        context.put("reason", new Element(event.getRegainReason().name()));
        context.put("amount", new Element(event.getAmount()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity heals", "entity heals because " + reason, entityType + " heals", entityType + " heals because " + reason), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setAmount(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityPortalEnter(EntityPortalEnterEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("location", new dLocation(event.getLocation()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        WorldScriptHelper.doEvents(Arrays.asList("entity enters portal", entityType + " enters portal"), npc, player, context);
    }

    @EventHandler
    public void entityPortalExit(EntityPortalExitEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("location", new dLocation(event.getTo()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        WorldScriptHelper.doEvents(Arrays.asList("entity exits portal", entityType + " exits portal"), npc, player, context);
    }

    @EventHandler
    public void entityShootBow(EntityShootBowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = null;
        dNPC npc = null;
        dItem bow = new dItem(event.getBow());
        dEntity projectile = new dEntity(event.getProjectile());
        dEntity entity = new dEntity((Entity)event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("bow", bow);
        context.put("projectile", projectile);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity shoots bow", "entity shoots " + bow.identify(), entityType + " shoots bow", entityType + " shoots " + bow.identify()), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesArgumentList(dEntity.class)) {
            List<dObject> list;
            event.setCancelled(true);
            List<dObject> newProjectiles = list = dList.valueOf(determination).filter(dEntity.class);
            for (dEntity dEntity2 : newProjectiles) {
                dEntity2.spawnAt(projectile.getLocation());
                if (!dEntity2.isProjectile()) continue;
                dEntity2.setShooter(entity);
            }
            Position.mount(Conversion.convert(newProjectiles));
            Entity lastProjectile = ((dEntity)newProjectiles.get(newProjectiles.size() - 1)).getBukkitEntity();
            lastProjectile.setVelocity(projectile.getVelocity());
        }
    }

    @EventHandler
    public void entityTame(EntityTameEvent event) {
        String determination;
        Player player = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("entity", entity);
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity tamed");
        events.add(entityType + " tamed");
        if (event.getOwner() instanceof Player) {
            player = (Player)event.getOwner();
            events.add("player tames entity");
            events.add("player tames " + entityType);
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityTarget(EntityTargetEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        final dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        String reason = event.getReason().name();
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity targets");
        events.add("entity targets because " + reason);
        events.add(entityType + " targets");
        events.add(entityType + " targets because " + reason);
        if (event.getTarget() != null) {
            dEntity target = new dEntity(event.getTarget());
            String targetType = target.getEntityType().name();
            context.put("target", target.getDenizenObject());
            if (target.isNPC()) {
                npc = target.getDenizenNPC();
                targetType = "npc";
            } else if (target.isPlayer()) {
                player = target.getPlayer();
            }
            events.add("entity targets entity");
            events.add("entity targets entity because " + reason);
            events.add("entity targets " + targetType);
            events.add("entity targets " + targetType + " because " + reason);
            events.add(entityType + " targets entity");
            events.add(entityType + " targets entity because " + reason);
            events.add(entityType + " targets " + targetType);
            events.add(entityType + " targets " + targetType + " because " + reason);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (dEntity.matches(determination)) {
            final dEntity newTarget = dEntity.valueOf(determination);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    entity.target(newTarget.getLivingEntity());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void entityTeleport(EntityTeleportEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("origin", new dLocation(event.getFrom()));
        context.put("destination", new dLocation(event.getTo()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity teleports", entityType + " teleports"), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityUnleash(EntityUnleashEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        String reason = event.getReason().name();
        context.put("entity", entity.getDenizenObject());
        context.put("reason", new Element(reason));
        WorldScriptHelper.doEvents(Arrays.asList("entity unleashed", "entity unleashed because " + reason, entityType + " unleashed", entityType + " unleashed because " + reason), null, null, context);
    }

    @EventHandler
    public void explosionPrimeEvent(ExplosionPrimeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity));
        context.put("radius", new Element(Float.valueOf(event.getRadius())));
        context.put("fire", new Element(event.getFire()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explosion primes", entity.getType().name() + " explosion primes"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void foodLevelChange(FoodLevelChangeEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("food", new Element(event.getFoodLevel()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity changes food level", entityType + " changes food level"), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setFoodLevel(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void horseJump(HorseJumpEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String variant = event.getEntity().getVariant().name();
        String color = event.getEntity().getColor().name();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("variant", new Element(variant));
        context.put("color", new Element(color));
        context.put("power", new Element(Float.valueOf(event.getPower())));
        context.put("entity", entity);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("horse jumps", variant + " jumps", color + " jumps", color + " " + variant + " jumps"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Float)) {
            event.setPower(aH.getFloatFrom(determination));
        }
    }

    @EventHandler
    public void itemDespawn(ItemDespawnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getEntity().getItemStack());
        dMaterial itemMaterial = item.getMaterial();
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getEntity()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("item despawns");
        events.add(item.identify() + " despawns");
        events.add(itemMaterial.identify() + " despawns");
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void itemSpawn(ItemSpawnEvent event) {
        String determination;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getEntity().getItemStack());
        dMaterial itemMaterial = item.getMaterial();
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getEntity()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("item spawns");
        events.add(item.identify() + " spawns");
        events.add(itemMaterial.identify() + " spawns");
        if (!item.identify().equals(item.identify().split(":")[0])) {
            events.add(item.identify().split(":")[0] + " spawns");
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, null, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void pigZap(PigZapEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity pig = new dEntity((Entity)event.getEntity());
        dEntity pigZombie = new dEntity((Entity)event.getPigZombie());
        dEntity lightning = new dEntity((Entity)event.getLightning());
        context.put("pig", pig);
        context.put("pig_zombie", pigZombie);
        context.put("lightning", lightning);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("pig zapped"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void projectileHit(ProjectileHitEvent event) {
        Player player = null;
        dNPC npc = null;
        dEntity projectile = new dEntity((Entity)event.getEntity());
        Block block = null;
        BlockIterator bi = new BlockIterator(projectile.getLocation().getWorld(), projectile.getLocation().toVector(), projectile.getLocation().getDirection().normalize(), 0.0, 4);
        while (bi.hasNext() && (block = bi.next()).getTypeId() == 0) {
        }
        String entityType = projectile.getEntityType().name();
        dEntity shooter = projectile.getShooter();
        dMaterial material = new dMaterial(block.getType());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("projectile", projectile);
        context.put("location", new dLocation(block.getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("projectile hits block");
        events.add("projectile hits " + material.identify());
        events.add(entityType + " hits block");
        events.add(entityType + " hits " + material.identify());
        if (shooter != null) {
            context.put("shooter", shooter.getDenizenObject());
            String shooterType = shooter.getEntityType().name();
            if (shooter.isNPC()) {
                npc = shooter.getDenizenNPC();
                shooterType = "npc";
            } else if (shooter.isPlayer()) {
                player = shooter.getPlayer();
            }
            events.add("entity shoots block");
            events.add("entity shoots block with " + entityType);
            events.add("entity shoots " + material.identify() + " with " + entityType);
            events.add(shooterType + " shoots block");
            events.add(shooterType + " shoots block with " + entityType);
            events.add(shooterType + " shoots " + material.identify() + " with " + entityType);
        }
        WorldScriptHelper.doEvents(events, npc, player, context);
    }

    @EventHandler
    public void sheepDyeWool(SheepDyeWoolEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String color = event.getColor().name();
        context.put("entity", entity);
        context.put("color", new Element(color));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player dyes sheep", "player dyes sheep " + color, "sheep dyed", "sheep dyed " + color), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.equals(determination.toUpperCase())) {
            try {
                event.setColor(DyeColor.valueOf((String)determination));
            }
            catch (IllegalArgumentException e) {
                dB.echoError("Unknown dye color " + determination);
            }
        }
    }

    @EventHandler
    public void sheepRegrowWool(SheepRegrowWoolEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("entity", entity);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("sheep regrows wool"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void slimeSplit(SlimeSplitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        int count = event.getCount();
        context.put("entity", entity);
        context.put("count", new Element(count));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("slime splits", "slime splits into " + count), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setCount(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void enchantItemEvent(EnchantItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = event.getEnchanter();
        dItem item = new dItem(event.getItem());
        context.put("location", new dLocation(event.getEnchantBlock().getLocation()));
        context.put("inventory", new dInventory(event.getInventory()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("item enchanted", item.identify() + " enchanted"), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        Player player = (Player)event.getWhoClicked();
        String type = event.getInventory().getType().name();
        String click = event.getClick().name();
        String slotType = event.getSlotType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        context.put("click", new Element(click));
        context.put("slot_type", new Element(slotType));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player clicks in inventory");
        events.add("player clicks in " + type);
        String interaction = "player " + click + " clicks";
        events.add(interaction + " in inventory");
        events.add(interaction + " in " + type);
        if (event.getCurrentItem() != null) {
            item = new dItem(event.getCurrentItem());
            dMaterial itemMaterial = item.getMaterial();
            events.add("player clicks " + item.identify() + " in inventory");
            events.add(interaction + item.identify() + " in inventory");
            events.add(interaction + item.identify() + " in " + type);
            events.add("player clicks " + itemMaterial.identify() + " in inventory");
            events.add(interaction + itemMaterial.identify() + " in inventory");
            events.add(interaction + itemMaterial.identify() + " in " + type);
        }
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(events, null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryCloseEvent(InventoryCloseEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = (Player)event.getPlayer();
        String type = event.getInventory().getType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        WorldScriptHelper.doEvents(Arrays.asList("player closes inventory", "player closes " + type), null, player, context);
    }

    @EventHandler
    public void inventoryDragEvent(InventoryDragEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        Player player = (Player)event.getWhoClicked();
        String type = event.getInventory().getType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player drags");
        events.add("player drags in inventory");
        events.add("player drags in " + type);
        if (event.getOldCursor() != null) {
            item = new dItem(event.getOldCursor());
            dMaterial itemMaterial = item.getMaterial();
            events.add("player drags " + item.identify());
            events.add("player drags " + item.identify() + " in inventory");
            events.add("player drags " + item.identify() + " in " + type);
            events.add("player drags " + itemMaterial.identify());
            events.add("player drags " + itemMaterial.identify() + " in inventory");
            events.add("player drags " + itemMaterial.identify() + " in " + type);
        }
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(events, null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryMoveItemEvent(InventoryMoveItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        String originType = event.getSource().getType().name();
        String destinationType = event.getDestination().getType().name();
        context.put("origin", new dInventory(event.getSource()));
        context.put("destination", new dInventory(event.getDestination()));
        context.put("initiator", new dInventory(event.getInitiator()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("item moves from inventory", "item moves from " + originType, "item moves from " + originType + " to " + destinationType, item.identify() + " moves from inventory", item.identify() + " moves from " + originType, item.identify() + " moves from " + originType + " to " + destinationType), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            event.setItem(dItem.valueOf(determination).getItemStack());
        }
    }

    @EventHandler
    public void inventoryOpenEvent(InventoryOpenEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = (Player)event.getPlayer();
        String type = event.getInventory().getType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player opens inventory", "player opens " + type), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryPickupItemEvent(InventoryPickupItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        dInventory inventory = new dInventory(event.getInventory());
        String type = inventory.getInventoryType().name();
        context.put("inventory", inventory);
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("inventory picks up item", "inventory picks up " + item.identify(), type + " picks up item", type + " picks up " + item.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void asyncPlayerChat(final AsyncPlayerChatEvent event) {
        if (!Settings.WorldScriptChatEventAsynchronous()) {
            return;
        }
        final HashMap<String, Element> context = new HashMap<String, Element>();
        context.put("message", new Element(event.getMessage()));
        Callable<String> call = new Callable<String>(){

            @Override
            public String call() {
                return WorldScriptHelper.doEvents(Arrays.asList("player chats"), null, event.getPlayer(), context);
            }
        };
        String determination = null;
        try {
            determination = event.isAsynchronous() ? (String)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (String)call.call();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (determination == null) {
            return;
        }
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (!determination.equals("none")) {
            event.setMessage(determination);
        }
    }

    @EventHandler
    public void playerAnimation(PlayerAnimationEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String animation = event.getAnimationType().name();
        context.put("animation", new Element(animation));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player animates", "player animates " + animation), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedEnter(PlayerBedEnterEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player enters bed"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedLeave(PlayerBedLeaveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        WorldScriptHelper.doEvents(Arrays.asList("player leaves bed"), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player empties bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            ItemStack is = dItem.valueOf(determination).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerBucketFill(PlayerBucketFillEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player fills bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            ItemStack is = dItem.valueOf(determination).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld originWorld = new dWorld(event.getFrom());
        dWorld destinationWorld = new dWorld(event.getPlayer().getWorld());
        context.put("origin_world", originWorld);
        WorldScriptHelper.doEvents(Arrays.asList("player changes world", "player changes world from " + originWorld.identify(), "player changes world to " + destinationWorld.identify(), "player changes world from " + originWorld.identify() + " to " + destinationWorld.identify()), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerChat(PlayerChatEvent event) {
        if (Settings.WorldScriptChatEventAsynchronous()) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player chats"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (!determination.equals("none")) {
            event.setMessage(determination);
        }
    }

    @EventHandler
    public void playerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dPlayer player = dPlayer.valueOf(event.getPlayer().getName());
        List<String> args = Arrays.asList(aH.buildArgs(TagManager.tag(player, null, event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : "")));
        dList args_list = new dList(args);
        String command = event.getMessage().split(" ")[0].replace("/", "").toUpperCase();
        context.put("args", args_list);
        context.put("command", new Element(command));
        context.put("raw_args", new Element(event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : ""));
        context.put("server", Element.FALSE);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("command", command + " command"), null, event.getPlayer(), context).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getDeathMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player dies", "player death"), null, event.getEntity(), context);
        if (!determination.equals("none")) {
            event.setDeathMessage(determination);
        }
    }

    @EventHandler
    public void playerDropItem(PlayerDropItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItemDrop().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItemDrop()));
        context.put("location", new dLocation(event.getItemDrop().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player drops item");
        events.add("player drops " + item.identify());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerEggThrow(PlayerEggThrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity egg = new dEntity((Entity)event.getEgg());
        context.put("egg", egg);
        context.put("is_hatching", new Element(event.isHatching()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player throws egg");
        if (event.isHatching()) {
            events.add("player throws hatching egg");
        } else {
            events.add("player throws non-hatching egg");
        }
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (dEntity.matches(determination)) {
            event.setHatching(true);
            event.setHatchingType(dEntity.valueOf(determination).getEntityType());
        }
    }

    @EventHandler
    public void playerFish(PlayerFishEvent event) {
        String determination;
        dNPC npc = null;
        String state = event.getState().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("hook", new dEntity((Entity)event.getHook()));
        context.put("state", new Element(state));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player fishes");
        events.add("player fishes while " + state);
        if (event.getCaught() != null) {
            dEntity entity = new dEntity(event.getCaught());
            String entityType = entity.getEntityType().name();
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
                entityType = "npc";
            }
            events.add("player fishes " + entityType);
            events.add("player fishes " + entityType + " while " + state);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerGameModeChange(PlayerGameModeChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("gamemode", new Element(event.getNewGameMode().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes gamemode", "player changes gamemode to " + event.getNewGameMode().name()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        String determination;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Action action = event.getAction();
        dItem item = null;
        dMaterial itemMaterial = null;
        ArrayList<String> events = new ArrayList<String>();
        String interaction = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? "player left clicks" : (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK ? "player right clicks" : "player stands on");
        events.add(interaction);
        if (event.hasItem()) {
            item = new dItem(event.getItem());
            itemMaterial = item.getMaterial();
            context.put("item", item);
            events.add(interaction + " with item");
            events.add(interaction + " with " + item.identify());
            events.add(interaction + " with " + itemMaterial.identify());
        }
        if (event.hasBlock()) {
            Block block = event.getClickedBlock();
            context.put("location", new dLocation(block.getLocation()));
            interaction = interaction + " " + block.getType().name();
            events.add(interaction);
            if (event.hasItem()) {
                events.add(interaction + " with item");
                events.add(interaction + " with " + item.identify());
                events.add(interaction + " with " + itemMaterial.identify());
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteractEntity(PlayerInteractEntityEvent event) {
        String determination;
        dNPC npc = null;
        dItem item = new dItem(event.getPlayer().getItemInHand());
        dMaterial itemMaterial = item.getMaterial();
        dEntity entity = new dEntity(event.getRightClicked());
        String entityType = entity.getEntityType().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRightClicked().getLocation()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("player right clicks entity");
        events.add("player right clicks " + entityType);
        events.add("player right clicks entity with " + item.identify());
        events.add("player right clicks " + entityType + " with " + item.identify());
        events.add("player right clicks entity with " + itemMaterial.identify());
        events.add("player right clicks " + entityType + " with " + itemMaterial.identify());
        if (entity.getBukkitEntity() instanceof ItemFrame) {
            dItem itemFrame = new dItem(((ItemFrame)entity.getBukkitEntity()).getItem());
            dMaterial itemFrameMaterial = itemFrame.getMaterial();
            context.put("itemframe", itemFrame);
            events.add("player right clicks " + entityType + " " + itemFrame.identify());
            events.add("player right clicks " + entityType + " " + itemFrameMaterial.identify());
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerItemConsume(PlayerItemConsumeEvent event) {
        dItem item = new dItem(event.getItem());
        dMaterial itemMaterial = item.getMaterial();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", item);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player consumes " + item.identify());
        events.add("player consumes " + itemMaterial.identify());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getJoinMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player joins", "player join"), null, event.getPlayer(), context);
        if (!determination.equals("none")) {
            event.setJoinMessage(determination);
        }
    }

    @EventHandler
    public void playerKick(PlayerKickEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getLeaveMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player kicked"), null, event.getPlayer(), context);
        if (!determination.equals("none")) {
            event.setLeaveMessage(determination);
        }
    }

    @EventHandler
    public void playerLeashEntity(PlayerLeashEntityEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("entity", entity);
        context.put("holder", new dEntity(event.getLeashHolder()));
        WorldScriptHelper.doEvents(Arrays.asList("player leashes entity", "entity leashes " + entityType), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerLevelChange(PlayerLevelChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("level", new Element(event.getNewLevel()));
        WorldScriptHelper.doEvents(Arrays.asList("player levels up", "player levels up to " + event.getNewLevel(), "player levels up from " + event.getOldLevel()), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerLogin(PlayerLoginEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("hostname", new Element(event.getHostname()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player logs in", "player login"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("KICKED")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, determination);
        }
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = dLocation.getSaved(event.getPlayer().getLocation());
        if (name != null) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("notable", new Element(name));
            String determination = WorldScriptHelper.doEvents(Arrays.asList("player walks over notable", "player walks over " + name, "walked over notable", "walked over " + name), null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED") || determination.toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void playerPickupItem(PlayerPickupItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItem()));
        context.put("location", new dLocation(event.getItem().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player picks up item");
        events.add("player picks up " + item.identify());
        events.add("player takes item");
        events.add("player takes " + item.identify());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getQuitMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player quits", "player quit"), null, event.getPlayer(), context);
        if (!determination.equals("none")) {
            event.setQuitMessage(determination);
        }
    }

    @EventHandler
    public void playerRespawn(PlayerRespawnEvent event) {
        dLocation location;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRespawnLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player respawns");
        if (event.isBedSpawn()) {
            events.add("player respawns at bed");
        } else {
            events.add("player respawns elsewhere");
        }
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (dLocation.matches(determination) && (location = dLocation.valueOf(determination)) != null) {
            event.setRespawnLocation((Location)location);
        }
    }

    @EventHandler
    public void playerShearEntity(PlayerShearEntityEvent event) {
        String determination;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        context.put("entity", entity);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player shears entity");
        events.add("player shears " + entityType);
        if (entity.getEntityType().equals((Object)EntityType.SHEEP)) {
            String color = ((Sheep)entity.getBukkitEntity()).getColor().name();
            events.add("player shears " + color + " sheep");
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleFlight(PlayerToggleFlightEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isFlying()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles flight", "player " + (event.isFlying() ? "starts" : "stops") + " flying"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSneak(PlayerToggleSneakEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSneaking()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles sneak", "player " + (event.isSneaking() ? "starts" : "stops") + " sneaking"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSprint(PlayerToggleSprintEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSprinting()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles sprint", "player " + (event.isSprinting() ? "starts" : "stops") + " sprinting"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void serverCommand(ServerCommandEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        List<String> args = Arrays.asList(aH.buildArgs(TagManager.tag(null, null, event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : "")));
        dList args_list = new dList(args);
        String command = event.getCommand().split(" ")[0].replace("/", "").toUpperCase();
        context.put("args", args_list);
        context.put("command", new Element(command));
        context.put("raw_args", new Element(event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("server", Element.TRUE);
        WorldScriptHelper.doEvents(Arrays.asList("command", command + " command"), null, null, context);
    }

    @EventHandler
    public void vehicleBlockCollision(VehicleBlockCollisionEvent event) {
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        dMaterial material = new dMaterial(event.getBlock().getType());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("location", new dLocation(event.getBlock().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with block");
        events.add("vehicle collides with " + material.identify());
        events.add(vehicleType + " collides with block");
        events.add(vehicleType + " collides with " + material.identify());
        WorldScriptHelper.doEvents(events, npc, player, context);
    }

    @EventHandler
    public void vehicleEntityCollision(VehicleEntityCollisionEvent event) {
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        dEntity entity = new dEntity(event.getEntity());
        String entityType = entity.getEntityType().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with entity");
        events.add("vehicle collides with " + entityType);
        events.add(vehicleType + " collides with entity");
        events.add(vehicleType + " collides with " + entityType);
        String determination = WorldScriptHelper.doEvents(events, npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("NOPICKUP")) {
            event.setPickupCancelled(true);
        }
    }

    @EventHandler
    public void vehicleCreate(VehicleCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        context.put("vehicle", vehicle);
        WorldScriptHelper.doEvents(Arrays.asList("vehicle created", vehicleType + " created"), null, null, context);
    }

    @EventHandler
    public void vehicleDamage(VehicleDamageEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("damage", new Element(event.getDamage()));
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle damaged");
        events.add(vehicleType + " damaged");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            String entityType = entity.getEntityType().name();
            context.put("entity", entity.getDenizenObject());
            if (entity.isPlayer()) {
                player = entity.getPlayer();
            } else {
                npc = entity.getDenizenNPC();
                entityType = "npc";
            }
            events.add("entity damages vehicle");
            events.add("entity damages " + vehicleType);
            events.add(entityType + " damages vehicle");
            events.add(entityType + " damages " + vehicleType);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void vehicleDestroy(VehicleDestroyEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle destroyed");
        events.add(vehicleType + " destroyed");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            String entityType = entity.getEntityType().name();
            context.put("entity", entity.getDenizenObject());
            if (entity.isPlayer()) {
                player = entity.getPlayer();
            } else {
                npc = entity.getDenizenNPC();
                entityType = "npc";
            }
            events.add("entity destroys vehicle");
            events.add("entity destroys " + vehicleType);
            events.add(entityType + " destroys vehicle");
            events.add(entityType + " destroys " + vehicleType);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleEnter(VehicleEnterEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        dEntity entity = new dEntity(event.getEntered());
        String entityType = entity.getEntityType().name();
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity enters vehicle", entityType + " enters vehicle", "entity enters " + vehicleType, entityType + " enters " + vehicleType), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleExit(VehicleExitEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        String vehicleType = vehicle.getEntityType().name();
        dEntity entity = new dEntity((Entity)event.getExited());
        String entityType = entity.getEntityType().name();
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
            entityType = "npc";
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity exits vehicle", "entity exits " + vehicleType, entityType + " exits vehicle", entityType + " exits " + vehicleType), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void lightningStrike(LightningStrikeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("location", new dLocation(event.getLightning().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("lightning strikes", "lightning strikes in " + world.identify()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void weatherChange(WeatherChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        ArrayList<String> events = new ArrayList<String>();
        events.add("weather changes");
        events.add("weather changes in " + world.identify());
        if (event.toWeatherState()) {
            context.put("weather", new Element("rain"));
            events.add("weather rains");
            events.add("weather rains in " + world.identify());
        } else {
            context.put("weather", new Element("clear"));
            events.add("weather clears");
            events.add("weather clears in " + world.identify());
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void portalCreate(PortalCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String reason = event.getReason().name();
        context.put("world", world);
        context.put("reason", new Element(reason));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("portal created", "portal created because " + reason, "portal created in " + world.identify(), "portal created in " + world.identify() + " because " + reason), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void spawnChange(SpawnChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("old_location", new dLocation(event.getPreviousLocation()));
        context.put("new_location", new dLocation(world.getWorld().getSpawnLocation()));
        WorldScriptHelper.doEvents(Arrays.asList("spawn changes", "spawn changes in " + world.identify()), null, null, context);
    }

    @EventHandler
    public void structureGrow(StructureGrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String treeType = event.getSpecies().name();
        context.put("world", world);
        context.put("location", new dLocation(event.getLocation()));
        context.put("structure", new Element(treeType));
        ArrayList<String> events = new ArrayList<String>();
        events.add("structure grows");
        events.add("structure grows in " + world.identify());
        events.add(treeType + " grows");
        events.add(treeType + " grows in " + world.identify());
        if (event.isFromBonemeal()) {
            events.add("structure grows from bonemeal");
            events.add("structure grows from bonemeal in " + world.identify());
            events.add(treeType + " grows from bonemeal");
            events.add(treeType + " grows from bonemeal in " + world.identify());
        } else {
            events.add("structure grows naturally");
            events.add("structure grows naturally in " + world.identify());
            events.add(treeType + " grows naturally");
            events.add(treeType + " grows naturally in " + world.identify());
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void worldInit(WorldInitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world initializes", world.identify() + " initializes"), null, null, context);
    }

    @EventHandler
    public void worldLoad(WorldLoadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world loads", world.identify() + " loads"), null, null, context);
    }

    @EventHandler
    public void worldSave(WorldSaveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world saves", world.identify() + " saves"), null, null, context);
    }

    @EventHandler
    public void worldUnload(WorldUnloadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world unloads", world.identify() + " unloads"), null, null, context);
    }
}

