/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.Properties;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.properties.ItemColor;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class dItem
implements dObject,
Notable,
Properties {
    static final Pattern ITEM_PATTERN = Pattern.compile("(?:item:)?([\\w ]+)[:,]?(\\d+)?\\[?(\\d+)?\\]?", 2);
    static final Class[] PROPERTIES = new Class[]{ItemColor.class};
    public static boolean nope = false;
    private ItemStack item = null;
    private String prefix = this.getObjectType();

    public static dItem valueOf(String string) {
        return dItem.valueOf(string, null, null);
    }

    @ObjectFetcher(value="i")
    public static dItem valueOf(String string, dPlayer player, dNPC npc) {
        block20: {
            Pattern item_by_saved;
            if (string == null) {
                return null;
            }
            dItem stack = null;
            Pattern item_by_entity_id = Pattern.compile("(i@)(\\d+)\\[?(\\d+)?\\]?");
            Matcher m = item_by_entity_id.matcher(string);
            if (m.matches()) {
                for (World world : Bukkit.getWorlds()) {
                    for (Item entity : world.getEntitiesByClass(Item.class)) {
                        if (entity.getEntityId() != Integer.valueOf(m.group(2)).intValue()) continue;
                        stack = new dItem(entity.getItemStack());
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
            }
            if ((m = (item_by_saved = Pattern.compile("(i@)(.+)\\[?(\\d+)?\\]?")).matcher(string)).matches() && NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dItem.class)) {
                stack = (dItem)NotableManager.getSavedObject(m.group(2));
                if (m.group(3) != null) {
                    stack.setAmount(Integer.valueOf(m.group(3)));
                }
                return stack;
            }
            m = ITEM_PATTERN.matcher(string = string.replace("i@", ""));
            if (m.matches()) {
                try {
                    if (ScriptRegistry.containsScript(m.group(1), ItemScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), ItemScriptContainer.class).getItemFrom(player, npc);
                    } else if (ScriptRegistry.containsScript(m.group(1), BookScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), BookScriptContainer.class).getBookFrom(player, npc);
                    }
                    if (stack != null) {
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    String material = m.group(1).toUpperCase();
                    stack = aH.matchesInteger(material) ? new dItem(Integer.valueOf(material)) : new dItem(Material.valueOf((String)material));
                    if (m.group(2) != null) {
                        stack.setDurability(Short.valueOf(m.group(2)));
                    }
                    if (m.group(3) != null) {
                        stack.setAmount(Integer.valueOf(m.group(3)));
                    }
                    return stack;
                }
                catch (Exception e) {
                    if (string.equalsIgnoreCase("none")) break block20;
                    dB.log("Does not match a valid item ID or material: " + string);
                }
            }
        }
        if (!nope) {
            dB.log("valueOf dItem returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        nope = true;
        if (dItem.valueOf(arg) != null) {
            nope = false;
            return true;
        }
        nope = false;
        return false;
    }

    public dItem(Material material) {
        this.item = new ItemStack(material);
    }

    public dItem(int itemId) {
        this.item = new ItemStack(itemId);
    }

    public dItem(Material material, int qty) {
        this.item = new ItemStack(material, qty);
    }

    public dItem(dMaterial material, int qty) {
        this.item = new ItemStack(material.getMaterial(), qty);
    }

    public dItem(int type, int qty) {
        this.item = new ItemStack(type, qty);
    }

    public dItem(ItemStack item) {
        this.item = item;
    }

    public dItem(Item item) {
        this.item = item.getItemStack();
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public int comparesTo(dItem item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack item) {
        if (item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        ItemStack compared_to = item;
        if (compared.getTypeId() != compared_to.getTypeId()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            if (compared_to.getItemMeta().hasDisplayName()) {
                if (!compared.getItemMeta().hasDisplayName()) {
                    return -1;
                }
                if (compared_to.getItemMeta().getDisplayName().toUpperCase().startsWith(compared.getItemMeta().getDisplayName().toUpperCase())) {
                    if (compared.getItemMeta().getDisplayName().length() > compared_to.getItemMeta().getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (compared_to.getItemMeta().hasLore()) {
                if (!compared.getItemMeta().hasLore()) {
                    return -1;
                }
                for (String string : compared_to.getItemMeta().getLore()) {
                    if (compared.getItemMeta().getLore().contains(string)) continue;
                    return -1;
                }
                if (compared.getItemMeta().getLore().size() > compared_to.getItemMeta().getLore().size()) {
                    ++determination;
                }
            }
            if (!compared_to.getItemMeta().getEnchants().isEmpty()) {
                if (compared.getItemMeta().getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : compared_to.getItemMeta().getEnchants().entrySet()) {
                    if (compared.getItemMeta().getEnchants().containsKey(entry.getKey()) && (Integer)compared.getItemMeta().getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (compared.getItemMeta().getEnchants().size() > compared_to.getItemMeta().getEnchants().size()) {
                    ++determination;
                }
            }
        }
        if (this.isRepairable()) {
            if (compared.getDurability() < compared_to.getDurability()) {
                ++determination;
            }
        } else if (this.getItemStack().getData().getData() != item.getData().getData()) {
            return -1;
        }
        return determination;
    }

    public boolean containsLore(String prefix) {
        if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
            for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                if (!itemLore.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLore(String prefix) {
        for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
            if (!itemLore.startsWith(prefix)) continue;
            return itemLore.substring(prefix.length());
        }
        return "";
    }

    public boolean isItemscript() {
        return this.containsLore("\u00a70id:");
    }

    public dMaterial getMaterial() {
        return new dMaterial(this.getItemStack().getType());
    }

    public String getMaterialName() {
        return this.getItemStack().getType().name().toLowerCase();
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public void setDurability(short value) {
        if (this.item != null) {
            this.item.setDurability(value);
        }
    }

    public void setData(byte value) {
        if (this.item != null) {
            this.item.getData().setData(value);
        }
    }

    public boolean isRepairable() {
        switch (this.getItemStack().getType()) {
            case BOW: 
            case DIAMOND_AXE: 
            case DIAMOND_HOE: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_SPADE: 
            case DIAMOND_SWORD: 
            case FISHING_ROD: 
            case GOLD_AXE: 
            case GOLD_HOE: 
            case GOLD_PICKAXE: 
            case GOLD_SPADE: 
            case GOLD_SWORD: 
            case IRON_AXE: 
            case IRON_HOE: 
            case IRON_PICKAXE: 
            case IRON_SPADE: 
            case IRON_SWORD: 
            case SHEARS: 
            case WOOD_AXE: 
            case WOOD_HOE: 
            case WOOD_PICKAXE: 
            case WOOD_SPADE: 
            case WOOD_SWORD: {
                return true;
            }
        }
        return this.getItemStack().getType().getId() >= Material.LEATHER_HELMET.getId() && this.getItemStack().getType().getId() <= Material.GOLD_BOOTS.getId();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dItem setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getObjectType() {
        return "Item";
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public String identify() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return "i@" + NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return "i@" + this.getLore("\u00a70id:");
            }
        }
        return "i@" + this.item.getType().name().toLowerCase();
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    public Object getSaveObject() {
        StringBuilder sb = new StringBuilder();
        sb.append("i@");
        sb.append(this.item.getType().name().toUpperCase());
        return sb.toString();
    }

    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    public void forget() {
        NotableManager.remove(this);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("qty")) {
            return new Element(this.getItemStack().getAmount()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("identify")) {
            return new Element(this.identify()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new Element(this.getItemStack().getTypeId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_stack")) {
            return new Element(this.getItemStack().getMaxStackSize()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(Integer.valueOf(this.getItemStack().getData().getData())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("durability")) {
            return new Element(this.getItemStack().getDurability()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("repairable")) {
            return new Element(this.isRepairable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material.formatted")) {
            String id = this.item.getType().name().toLowerCase();
            if (id.equals("air")) {
                return new Element("nothing").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("ice") || id.equals("dirt")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (this.getItemStack().getAmount() > 1) {
                if (id.equals("cactus")) {
                    return new Element("cactuses").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("y")) {
                    return new Element(id.substring(0, id.length() - 1) + "ies").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("s")) {
                    return new Element(id).getAttribute(attribute.fulfill(2));
                }
                return new Element(id + "s").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("cactus")) {
                return new Element("a cactus").getAttribute(attribute.fulfill(2));
            }
            if (id.endsWith("s")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                return new Element("an " + id).getAttribute(attribute.fulfill(2));
            }
            return new Element("a " + id).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("material")) {
            return this.getMaterial().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("display") && this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasDisplayName()) {
            return new Element(this.getItemStack().getItemMeta().getDisplayName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments") && this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasEnchants()) {
            ArrayList<String> enchants = new ArrayList<String>();
            for (Enchantment enchantment : this.getItemStack().getEnchantments().keySet()) {
                enchants.add(enchantment.getName());
            }
            return new dList((List<String>)enchants).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("book")) {
            if (this.getItemStack().getType() == Material.WRITTEN_BOOK) {
                attribute.fulfill(1);
                BookMeta bookInfo = (BookMeta)this.getItemStack().getItemMeta();
                if (attribute.startsWith("author")) {
                    return new Element(bookInfo.getAuthor()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    return new Element(bookInfo.getTitle()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("page_count")) {
                    return new Element(bookInfo.getPageCount()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("get_page") && aH.matchesInteger(attribute.getContext(1))) {
                    return new Element(bookInfo.getPage(attribute.getIntContext(1))).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("pages")) {
                    return new dList(bookInfo.getPages()).getAttribute(attribute.fulfill(1));
                }
            } else {
                dB.echoError("Item referenced is not a written book!");
                return "null";
            }
        }
        if (attribute.startsWith("scriptname") && this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
            for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                if (!itemLore.startsWith("\u00a70id:")) continue;
                return new Element(itemLore.substring(5)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("lore")) {
            if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
                ArrayList<String> loreList = new ArrayList<String>();
                for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                    if (itemLore.startsWith("\u00a70id:")) continue;
                    loreList.add(itemLore);
                }
                return new dList((List<String>)loreList).getAttribute(attribute.fulfill(1));
            }
            return new dList("").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

