/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;

public class SpawnCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("spread") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("spread", arg.asElement());
                continue;
            }
            dB.echoError(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        scriptEntry.defaultObject("location", scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null);
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ENTITIES");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dEntity target = (dEntity)scriptEntry.getObject("target");
        Element spread = scriptEntry.getElement("spread");
        dB.report(this.getName(), aH.debugObj("entities", entities.toString()) + location.debug() + (spread != null ? spread.debug() : "") + (target != null ? target.debug() : ""));
        dList entityList = new dList();
        for (dEntity entity : entities) {
            Location loc = location.clone();
            if (spread != null) {
                loc.add((double)(Utilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt()), 0.0, (double)(Utilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt()));
            }
            entity.spawnAt(loc);
            entityList.add(entity.toString());
            if (target == null || !target.isLivingEntity()) continue;
            entity.target(target.getLivingEntity());
        }
        scriptEntry.addObject("spawned_entities", entityList);
    }
}

