/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import org.bukkit.util.Vector;

public class Velocity {
    public static Vector calculate(Vector from, Vector to, double gravity, double heightGain) {
        int endGain = to.getBlockY() - from.getBlockY();
        double horizDist = Math.sqrt(Velocity.distanceSquared(from, to));
        double maxGain = heightGain > (double)endGain + heightGain ? heightGain : (double)endGain + heightGain;
        double a = -horizDist * horizDist / (4.0 * maxGain);
        double b = horizDist;
        double c = -endGain;
        double slope = -b / (2.0 * a) - Math.sqrt(b * b - 4.0 * a * c) / (2.0 * a);
        double vy = Math.sqrt(maxGain * (gravity + 0.0013675090252708 * heightGain));
        double vh = vy / slope;
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        double mag = Math.sqrt(dx * dx + dz * dz);
        double dirx = (double)dx / mag;
        double dirz = (double)dz / mag;
        double vx = vh * dirx;
        double vz = vh * dirz;
        return new Vector(vx, vy, vz);
    }

    private static double distanceSquared(Vector from, Vector to) {
        double dx = to.getBlockX() - from.getBlockX();
        double dz = to.getBlockZ() - from.getBlockZ();
        return dx * dx + dz * dz;
    }
}

