/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class VulnerableCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Toggle vulnerable = Toggle.TRUE;
        for (String arg : scriptEntry.getArguments()) {
            if (!aH.matchesState(arg)) continue;
            vulnerable = Toggle.valueOf(aH.getStringFrom(arg).toUpperCase());
        }
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("vulnerable", (Object)vulnerable);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Toggle toggle = (Toggle)((Object)scriptEntry.getObject("vulnerable"));
        dB.report(this.getName(), aH.debugObj("NPC", scriptEntry.getNPC().toString()) + aH.debugObj("Toggle", toggle.toString()));
        NPC npc = scriptEntry.getNPC().getCitizen();
        boolean vulnerable = toggle == Toggle.TOGGLE ? (Boolean)npc.data().get("protected", (Object)true) == false : Boolean.valueOf(toggle.toString());
        npc.data().set("protected", (Object)(!vulnerable ? 1 : 0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Toggle {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

