/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.Delayable;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class WaitCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ScriptQueue queue = scriptEntry.getResidingQueue();
        Duration delay = new Duration(3);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                delay = Duration.valueOf(arg);
            }
            if (!aH.matchesQueue(arg)) continue;
            queue = ScriptQueue._getExistingQueue(arg);
        }
        scriptEntry.addObject("queue", queue);
        scriptEntry.addObject("delay", delay);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        if (queue instanceof Delayable) {
            ((Delayable)((Object)queue)).delayFor(delay);
            dB.echoDebug("Delaying " + delay.identify());
        } else {
            dB.echoError("This type of queue is not able to be delayed!");
        }
    }
}

