/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import net.aufdemrand.denizen.utilities.midi.ToneUtil;
import org.bukkit.Location;
import org.bukkit.Sound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteBlockReceiver
implements Receiver {
    private static final float VOLUME_RANGE = 10.0f;
    private List<dEntity> entities;
    private dLocation location;
    private final Map<Integer, Integer> channelPatches;
    private Collection<dEntity> unusedEntities = new LinkedList<dEntity>();

    public NoteBlockReceiver(List<dEntity> entities) throws InvalidMidiDataException, IOException {
        this.entities = entities;
        this.location = null;
        this.channelPatches = Maps.newHashMap();
    }

    public NoteBlockReceiver(dLocation location) throws InvalidMidiDataException, IOException {
        this.entities = null;
        this.location = location;
        this.channelPatches = Maps.newHashMap();
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        if (144 != message.getCommand()) {
            return;
        }
        int channel = message.getChannel();
        if (channel == 9) {
            return;
        }
        Integer patch = this.channelPatches.get(channel);
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = 10.0f * ((float)message.getData2() / 127.0f);
        Sound instrument = Sound.NOTE_PIANO;
        if (patch != null) {
            instrument = MidiUtil.patchToInstrument(patch);
        }
        if (this.location != null) {
            this.location.getWorld().playSound((Location)this.location, instrument, volume, pitch);
        } else if (this.entities != null && !this.entities.isEmpty()) {
            for (dEntity entity : this.entities) {
                if (entity.isSpawned()) {
                    if (entity.isPlayer()) {
                        entity.getPlayer().playSound((Location)entity.getLocation(), instrument, volume, pitch);
                        continue;
                    }
                    entity.getWorld().playSound((Location)entity.getLocation(), instrument, volume, pitch);
                    continue;
                }
                this.unusedEntities.add(entity);
            }
            if (!this.unusedEntities.isEmpty()) {
                for (dEntity unusedEntity : this.unusedEntities) {
                    this.entities.remove(unusedEntity);
                }
                this.unusedEntities.clear();
            }
        } else {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.entities != null) {
            this.entities = null;
        }
        if (this.location != null) {
            this.location = null;
        }
        this.channelPatches.clear();
    }
}

