/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BracedCommand
extends AbstractCommand {
    public final boolean hyperdebug = false;

    public LinkedHashMap<String, ArrayList<ScriptEntry>> getBracedCommands(ScriptEntry scriptEntry, int startArg) throws InvalidArgumentsException {
        TreeMap commandList = new TreeMap();
        LinkedHashMap<String, ArrayList<ScriptEntry>> bracedSections = new LinkedHashMap<String, ArrayList<ScriptEntry>>();
        int bracesEntered = 0;
        boolean newCommand = true;
        boolean waitingForDash = false;
        scriptEntry.getResidingQueue().injectEntry(scriptEntry, 0);
        ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
        List<aH.Argument> argList = aH.interpret(entry.getArguments());
        String bracesName = scriptEntry.getCommandName();
        for (int i = startArg; i < argList.size(); ++i) {
            aH.Argument arg = argList.get(i);
            if (arg.matches("{")) {
                newCommand = false;
                boolean bl = waitingForDash = ++bracesEntered == 1;
                if (bracesEntered <= 1) continue;
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                continue;
            }
            if (arg.matches("}")) {
                newCommand = false;
                if (--bracesEntered > 0) {
                    ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                    continue;
                }
                if (bracedSections.containsKey(bracesName)) {
                    dB.echoError("You may not have braced commands with the same arguments.");
                    break;
                }
                ArrayList<ScriptEntry> bracesSection = new ArrayList<ScriptEntry>();
                for (ArrayList command : commandList.values()) {
                    try {
                        if (command.isEmpty()) continue;
                        String cmd = (String)command.get(0);
                        command.remove(0);
                        String[] args = new String[command.size()];
                        args = command.toArray(args);
                        bracesSection.add(new ScriptEntry(cmd, args, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null));
                        ((ScriptEntry)bracesSection.get(bracesSection.size() - 1)).setPlayer(scriptEntry.getPlayer());
                        ((ScriptEntry)bracesSection.get(bracesSection.size() - 1)).setNPC(scriptEntry.getNPC());
                    }
                    catch (ScriptEntryCreationException e) {}
                }
                bracedSections.put(bracesName.toUpperCase(), bracesSection);
                bracesName = "";
                continue;
            }
            if (newCommand && bracesEntered == 1) {
                commandList.put(commandList.size(), new ArrayList());
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                newCommand = false;
                continue;
            }
            if (arg.matches("-") && bracesEntered == 1) {
                newCommand = true;
                waitingForDash = false;
                continue;
            }
            if (bracesEntered == 0) {
                bracesName = bracesName + arg.raw_value;
                continue;
            }
            if (waitingForDash) {
                dB.echoError("Malformed braced section! Missing a - symbol!");
                break;
            }
            newCommand = false;
            ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
        }
        scriptEntry.getResidingQueue().removeEntry(0);
        return bracedSections;
    }
}

