/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;

public class MountCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            dB.echoError(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        scriptEntry.defaultObject("location", scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null, scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null);
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ENTITIES");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        List entities = (List)scriptEntry.getObject("entities");
        boolean cancel = scriptEntry.hasObject("cancel");
        dB.report(this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("location", location) + aH.debugObj("entities", entities.toString()));
        if (!cancel) {
            for (dEntity entity : entities) {
                entity.spawnAt(location);
            }
            Position.mount(Conversion.convert(entities));
        } else {
            Position.dismount(Conversion.convert(entities));
        }
    }
}

