/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class EngageCommand
extends AbstractCommand {
    private static Map<NPC, Long> currentlyEngaged = new HashMap<NPC, Long>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Duration duration = null;
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesInteger(arg) || aH.matchesDuration(arg)) {
                duration = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesArg("NOW", arg)) continue;
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT);
        }
        if (duration == null) {
            duration = new Duration(15.0);
        }
        scriptEntry.addObject("duration", duration);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(this.getName(), aH.debugObj("NPC", scriptEntry.getNPC().toString()) + duration.debug());
        if (duration.getSecondsAsInt() > 0) {
            EngageCommand.setEngaged(scriptEntry.getNPC().getCitizen(), duration.getSecondsAsInt());
        } else {
            EngageCommand.setEngaged(scriptEntry.getNPC().getCitizen(), true);
        }
    }

    public static boolean getEngaged(NPC npc) {
        return currentlyEngaged.containsKey(npc) && currentlyEngaged.get(npc) > System.currentTimeMillis();
    }

    public static void setEngaged(NPC npc, boolean engaged) {
        if (engaged) {
            currentlyEngaged.put(npc, System.currentTimeMillis() + (long)Duration.valueOf(Settings.EngageTimeoutInSeconds()).getSeconds() * 1000L);
        }
        if (!engaged) {
            currentlyEngaged.remove(npc);
        }
    }

    public static void setEngaged(NPC npc, int duration) {
        currentlyEngaged.put(npc, System.currentTimeMillis() + (long)(duration * 1000));
    }
}

