/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class FollowCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("stop") && arg.matches("STOP")) {
                scriptEntry.addObject("stop", true);
                continue;
            }
            if (!scriptEntry.hasObject("lead") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("lead", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("target", arg.asType(dEntity.class));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("target")) {
            if (scriptEntry.hasPlayer()) {
                scriptEntry.addObject("target", scriptEntry.getPlayer().getDenizenEntity());
            } else {
                throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Boolean stop = (Boolean)scriptEntry.getObject("stop");
        Element lead = (Element)scriptEntry.getObject("lead");
        dEntity target = (dEntity)scriptEntry.getObject("target");
        dB.report(this.getName(), (scriptEntry.getPlayer() != null ? scriptEntry.getPlayer().debug() : "") + (stop == null ? aH.debugObj("Action", "FOLLOW") : aH.debugObj("Action", "STOP")) + (lead != null ? aH.debugObj("Lead", lead.toString()) : "") + target.debug());
        if (lead != null) {
            scriptEntry.getNPC().getNavigator().getLocalParameters().distanceMargin(lead.asDouble());
        }
        if (stop != null) {
            scriptEntry.getNPC().getNavigator().cancelNavigation();
        } else {
            scriptEntry.getNPC().getNavigator().setTarget(target.getBukkitEntity(), false);
        }
    }
}

