/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dLocation location = null;
        FireworkEffect.Type type = FireworkEffect.Type.BALL;
        Integer power = 1;
        Boolean flicker = false;
        Boolean trail = false;
        ArrayList<Color> primary = new ArrayList<Color>();
        ArrayList<Color> fade = new ArrayList<Color>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesValueArg("type", arg, aH.ArgumentType.String)) {
                String typeArg = arg.split(":", 2)[1].toUpperCase();
                if (typeArg.matches("RANDOM")) {
                    type = FireworkEffect.Type.values()[Utilities.getRandom().nextInt(FireworkEffect.Type.values().length)];
                } else {
                    for (FireworkEffect.Type typeValue : FireworkEffect.Type.values()) {
                        if (!typeArg.matches(typeValue.name())) continue;
                        type = typeValue;
                        break;
                    }
                }
                dB.echoDebug("...will be of type " + type);
                continue;
            }
            if (aH.matchesValueArg("power", arg, aH.ArgumentType.Integer)) {
                power = aH.getIntegerFrom(arg);
                dB.echoDebug("...will have a power of " + power);
                continue;
            }
            if (aH.matchesArg("flicker", arg)) {
                flicker = true;
                dB.echoDebug("...will flicker.");
                continue;
            }
            if (aH.matchesArg("trail", arg)) {
                trail = true;
                dB.echoDebug("...will have a trail.");
                continue;
            }
            if (aH.matchesValueArg("PRIMARY", arg, aH.ArgumentType.String)) {
                for (String element : aH.getListFrom(arg)) {
                    if (dColor.matches(element)) {
                        primary.add(dColor.valueOf(element).getColor());
                        continue;
                    }
                    dB.echoError("Invalid color " + element + "!");
                }
                continue;
            }
            if (aH.matchesValueArg("FADE", arg, aH.ArgumentType.String)) {
                for (String element : aH.getListFrom(arg)) {
                    if (dColor.matches(element)) {
                        fade.add(dColor.valueOf(element).getColor());
                        continue;
                    }
                    dB.echoError("Invalid color " + element + "!");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("type", type);
        scriptEntry.addObject("primary", primary);
        scriptEntry.addObject("fade", fade);
        scriptEntry.addObject("power", power);
        scriptEntry.addObject("flicker", flicker);
        scriptEntry.addObject("trail", trail);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : scriptEntry.getNPC().getLocation();
        Integer power = (Integer)scriptEntry.getObject("power");
        Boolean flicker = (Boolean)scriptEntry.getObject("flicker");
        Boolean trail = (Boolean)scriptEntry.getObject("trail");
        FireworkEffect.Type type = (FireworkEffect.Type)scriptEntry.getObject("type");
        List primary = (List)scriptEntry.getObject("primary");
        List fade = (List)scriptEntry.getObject("fade");
        Firework firework = (Firework)location.getWorld().spawn((Location)location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.setPower(power.intValue());
        FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
        fireworkBuilder.with(type);
        if (primary.size() == 0) {
            primary.add(dColor.valueOf("yellow").getColor());
        }
        fireworkBuilder.withColor((Iterable)primary);
        fireworkBuilder.withFade((Iterable)fade);
        if (flicker.booleanValue()) {
            fireworkBuilder.withFlicker();
        }
        if (trail.booleanValue()) {
            fireworkBuilder.withTrail();
        }
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkBuilder.build()});
        firework.setFireworkMeta(fireworkMeta);
    }
}

