/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.LeatherColorer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemScriptContainer
extends ScriptContainer {
    dNPC npc = null;
    dPlayer player = null;
    public boolean bound = false;
    List<dItem> recipe = null;

    public ItemScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        if (this.contains("RECIPE")) {
            this.recipe = new ArrayList<dItem>();
            for (String recipeRow : this.getStringList("RECIPE")) {
                String[] row;
                recipeRow = TagManager.tag(this.player, this.npc, recipeRow);
                for (String material : row = recipeRow.split("\\|", 3)) {
                    this.recipe.add(this.recipe.size(), dItem.valueOf(material));
                }
            }
            ShapedRecipe shapedRecipe = new ShapedRecipe(this.getItemFrom().getItemStack());
            shapedRecipe.shape(new String[]{"abc", "def", "ghi"});
            char x = 'a';
            for (dItem material : this.recipe) {
                if (!material.getItemStack().getType().name().equals("AIR")) {
                    shapedRecipe.setIngredient(x, material.getItemStack().getData());
                }
                x = (char)(x + 1);
            }
            Bukkit.getServer().addRecipe((Recipe)shapedRecipe);
        }
    }

    public dItem getItemFrom() {
        return this.getItemFrom(null, null);
    }

    public List<dItem> getRecipe() {
        return this.recipe;
    }

    public dItem getItemFrom(dPlayer player, dNPC npc) {
        dItem stack = null;
        try {
            if (this.contains("MATERIAL")) {
                String material = TagManager.tag(player, npc, this.getString("MATERIAL"));
                stack = dItem.valueOf(material);
            }
            if (stack == null) {
                return null;
            }
            ItemMeta meta = stack.getItemStack().getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a70id:" + this.getName());
            if (this.contains("DISPLAY NAME")) {
                String displayName = TagManager.tag(player, npc, this.getString("DISPLAY NAME"));
                meta.setDisplayName(displayName);
            }
            if (this.contains("BOUND")) {
                this.bound = Boolean.valueOf(TagManager.tag(player, npc, this.getString("BOUND")));
            }
            if (this.contains("LORE")) {
                for (String l : this.getStringList("LORE")) {
                    l = TagManager.tag(player, npc, l);
                    lore.add(l);
                }
            }
            meta.setLore(lore);
            stack.getItemStack().setItemMeta(meta);
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    enchantment = TagManager.tag(player, npc, enchantment);
                    try {
                        int level = 1;
                        if (enchantment.split(":").length > 1) {
                            level = Integer.valueOf(enchantment.split(":")[1]);
                            enchantment = enchantment.split(":")[0];
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.getItemStack().addUnsafeEnchantment(ench, level);
                    }
                    catch (Exception e) {
                        dB.echoError("While constructing '" + this.getName() + "', there has been a problem. '" + enchantment + "' is an invalid Enchantment!");
                    }
                }
            }
            if (this.contains("COLOR")) {
                String color = TagManager.tag(player, npc, this.getString("COLOR"));
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = ScriptRegistry.getScriptContainerAs(this.getString("BOOK").replace("s@", ""), BookScriptContainer.class);
                stack = book.writeBookTo(stack, player, npc);
            }
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this item script!");
            if (!dB.showStackTraces) {
                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
            } else {
                e.printStackTrace();
            }
            stack = null;
        }
        return stack;
    }

    public void setNPC(dNPC npc) {
        this.npc = npc;
    }

    public void setPlayer(dPlayer player) {
        this.player = player;
    }
}

