/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ObjectFetcher {
    private static Map<String, Class> objects = new HashMap<String, Class>();
    private static ArrayList<Class> fetchable_objects = new ArrayList();

    public static void _initialize() throws IOException, ClassNotFoundException {
        if (fetchable_objects.isEmpty()) {
            return;
        }
        HashMap<String, Class> adding = new HashMap<String, Class>();
        for (Class dClass : fetchable_objects) {
            for (Method method : dClass.getMethods()) {
                String[] identifiers;
                if (!method.isAnnotationPresent(net.aufdemrand.denizen.objects.ObjectFetcher.class)) continue;
                for (String identifer : identifiers = method.getAnnotation(net.aufdemrand.denizen.objects.ObjectFetcher.class).value().split(",")) {
                    adding.put(identifer.trim().toLowerCase(), dClass);
                }
            }
        }
        objects.putAll(adding);
        dB.echoApproval("Added objects to the ObjectFetcher " + adding.keySet().toString());
        fetchable_objects.clear();
    }

    public static void registerWithObjectFetcher(Class dObject2) {
        fetchable_objects.add(dObject2);
    }

    public static boolean canFetch(String id) {
        return objects.containsKey(id.toLowerCase());
    }

    public static Class getObjectClass(String id) {
        if (ObjectFetcher.canFetch(id)) {
            return objects.get(id.toLowerCase());
        }
        return null;
    }
}

