/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ZombieModifier;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;

public class EntityInfected
implements Property {
    dEntity infected;

    public static boolean describes(dEntity entity) {
        return entity.getEntityType() == EntityType.ZOMBIE || entity.getEntityType() == EntityType.VILLAGER;
    }

    public static EntityInfected getFrom(dEntity entity) {
        if (!EntityInfected.describes(entity)) {
            return null;
        }
        return new EntityInfected(entity);
    }

    private EntityInfected(dEntity item) {
        this.infected = item;
    }

    public boolean isInfected() {
        return this.infected.getBukkitEntity() instanceof Zombie && ((Zombie)this.infected.getBukkitEntity()).isVillager();
    }

    public void setInfected(boolean bool) {
        if (bool) {
            if (this.infected.isNPC()) {
                NPC infected_npc = this.infected.getNPC();
                infected_npc.setBukkitEntityType(EntityType.ZOMBIE);
                if (!((ZombieModifier)infected_npc.getTrait(ZombieModifier.class)).toggleVillager()) {
                    ((ZombieModifier)infected_npc.getTrait(ZombieModifier.class)).toggleVillager();
                }
            } else if (this.infected.getBukkitEntity() instanceof Villager) {
                Entity infect = this.infected.getLocation().getWorld().spawnEntity((Location)this.infected.getLocation(), EntityType.ZOMBIE);
                ((Zombie)infect).setVillager(true);
                ((Zombie)infect).setHealth(((Villager)this.infected.getBukkitEntity()).getHealth());
                ((Zombie)infect).getEquipment().setArmorContents(((Villager)this.infected.getBukkitEntity()).getEquipment().getArmorContents());
                this.infected.getBukkitEntity().remove();
                this.infected.setEntity(infect);
            } else if (this.infected.getBukkitEntity() instanceof Zombie) {
                ((Zombie)this.infected).setVillager(true);
            }
        }
    }

    public String getPropertyString() {
        return this.getPropertyId() + '=' + this.isInfected() + ';';
    }

    public String getPropertyId() {
        return "infected";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("is_infected")) {
            return new Element(this.isInfected()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

