/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.TargetType;

public class AttackCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel, stop")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            dB.echoError(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        scriptEntry.defaultObject("target", scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getDenizenEntity() : null);
        scriptEntry.defaultObject("entities", scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null);
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ENTITIES");
        }
        if (!scriptEntry.hasObject("target") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "TARGET");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dEntity target = (dEntity)scriptEntry.getObject("target");
        Boolean cancel = scriptEntry.hasObject("cancel");
        dB.report(this.getName(), (cancel == true ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("entities", entities.toString()) + (target != null ? aH.debugObj("target", target) : ""));
        for (dEntity entity : entities) {
            if (entity.isNPC()) {
                Navigator nav = entity.getNPC().getNavigator();
                if (cancel.equals(false)) {
                    nav.setTarget(target.getBukkitEntity(), true);
                    continue;
                }
                if (!nav.isNavigating() || !nav.getTargetType().equals((Object)TargetType.ENTITY) || !nav.getEntityTarget().isAggressive()) continue;
                nav.cancelNavigation();
                continue;
            }
            if (cancel.equals(false)) {
                entity.target(target.getLivingEntity());
                continue;
            }
            entity.target(null);
        }
    }
}

