/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Arrays;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.npc.ai.BlockBreaker;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;

public class BreakCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entity", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("entities", scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null, scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null);
        scriptEntry.defaultObject("radius", new Element(1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        final dLocation location = (dLocation)scriptEntry.getObject("location");
        final dEntity entity = (dEntity)scriptEntry.getObject("entity");
        Element radius = scriptEntry.getElement("radius");
        dB.report(this.getName(), location.debug() + entity.debug() + radius.debug());
        BlockBreaker.Configuration config = new BlockBreaker.Configuration().item(entity.getLivingEntity().getEquipment().getItemInHand()).radius(radius.asDouble()).callback(new Runnable(){

            public void run() {
                dB.echoDebug(entity.debug() + " dug " + location.debug());
            }
        });
        BlockBreaker breaker = BlockBreaker.createWithConfiguration((LivingEntity)entity.getLivingEntity(), (Block)location.getBlock(), (BlockBreaker.Configuration)config);
        breaker.run();
    }
}

