/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("volume, v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("pitch, p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrimitive(aH.PrimitiveType.String)) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "SOUND");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
        scriptEntry.defaultObject("volume", new Element(1));
        scriptEntry.defaultObject("pitch", new Element(1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element sound = scriptEntry.getElement("sound");
        Element volume = scriptEntry.getElement("volume");
        Element pitch = scriptEntry.getElement("pitch");
        dB.report(this.getName(), location.debug() + sound.debug() + volume.debug() + pitch.debug());
        try {
            location.getWorld().playSound((Location)location, Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat());
        }
        catch (Exception e) {
            dB.echoError("Invalid sound!");
        }
    }
}

