/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.Iterator;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class StandCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Iterator<String> i$ = scriptEntry.getArguments().iterator();
        if (i$.hasNext()) {
            String arg = i$.next();
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        NPC npc = scriptEntry.getNPC().getCitizen();
        SittingTrait trait = (SittingTrait)npc.getTrait(SittingTrait.class);
        if (!npc.hasTrait(SittingTrait.class)) {
            npc.addTrait(SittingTrait.class);
            dB.echoDebug("...added sitting trait");
        }
        if (!trait.isSitting()) {
            dB.echoError("...NPC is already standing, removing trait");
            npc.removeTrait(SittingTrait.class);
            return;
        }
        trait.stand();
        npc.removeTrait(SittingTrait.class);
    }
}

